% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ch_booth_plot.R
\name{ch_booth_plot}
\alias{ch_booth_plot}
\title{Create Booth plot of peaks over a threshold}
\usage{
ch_booth_plot(events, threshold, title, type = "mag", colour1 = 1, colour2 = 1)
}
\arguments{
\item{events}{A data frame of POT events from the function \code{ch_get_peaks}}

\item{threshold}{The threshold used by \code{ch_get_peaks}}

\item{title}{Plot title}

\item{type}{The plot type, either \option{mag} (magnitude, the default) or \option{vol} (volume)}

\item{colour1}{A vector of length 12 with line colours of rings or symbols. Defaults to those used by Booth.}

\item{colour2}{A vector of length 12 with fill colours of rings or symbols. Defaults to those used by Booth.}
}
\value{
No value is returned; a standard \R graphic is created.
}
\description{
A Booth plot is a plot of peaks over threshold flood events with duration on the horizontal and
either magnitude (default) or volume on the vertical axis.
}
\examples{
threshold <- 0.1 * max(CAN05AA008$Flow)  # arbitrary threshold
peaks <- ch_get_peaks(CAN05AA008, threshold)
events <- peaks$POTevents
ch_booth_plot(events, threshold, title = "05AA008", type='mag')
ch_booth_plot(events, threshold, title = "05AA008", type='vol')
}
\references{
Booth, E.G., Mount, J.F., Viers, J.H. 2006. Hydrologic Variability of the Cosumnes River Floodplain.
San Francisco Estuary & Watershed Science 4:21.

Whitfield, P.H., and J.W. Pomeroy. 2016. Changes to flood peaks of a mountain river: implications
for analysis of the 2013 flood in the Upper Bow River, Canada. Hydrological Processes 30:4657-73. doi:
10.1002/hyp.10957.
}
\seealso{
\code{\link{ch_get_peaks}}
}
\author{
Paul Whitfield
}
\keyword{plot}
