<a href="https://covid19datahub.io"><img src="https://storage.covid19datahub.io/logo.svg" align="right" height="128"/></a>

# Coronavirus COVID-19 (2019-nCoV) Epidemic Datasets

![](https://www.r-pkg.org/badges/version/COVID19) ![](https://www.r-pkg.org/badges/last-release/COVID19) ![](https://cranlogs.r-pkg.org/badges/grand-total/COVID19) [![](https://img.shields.io/badge/doi-10.13140/RG.2.2.11649.81763-orange.svg)](https://doi.org/10.13140/RG.2.2.11649.81763)

The repository aims at unifying COVID-19 datasets across different sources in order to simplify the data acquisition process and the subsequent analysis. __You are welcome to join__ and [contribute](https://github.com/covid19datahub/COVID19/blob/master/CONTRIBUTING.md) by extending the number of supporting data sources as a joint effort against COVID-19.

The data are available to the end-user via the [R package COVID19](https://cran.r-project.org/package=COVID19) or in csv format (see below or on [Kaggle](https://www.kaggle.com/eguidotti/coronavirus-covid19-2019ncov-epidemic-datasets/)).

## About

### Goal

Provide the research community with a unified data hub by collecting worldwide fine-grained data merged with demographics, air pollution, and other exogenous variables helpful for a better understanding of COVID-19.

### How 

The data are collected with the [R package COVID19](https://cran.r-project.org/package=COVID19). For R users, the COVID19 package is the recommended way to interact with the dataset. For non R users, the data are provided in csv format and regularly updated (see below or on [Kaggle](https://www.kaggle.com/eguidotti/coronavirus-covid19-2019ncov-epidemic-datasets/)).

### Join the mission

Whether or not you are an R user... take part in the data collection!

- See [how to contribute](https://github.com/covid19datahub/COVID19/blob/master/CONTRIBUTING.md) to get started
- Join us on [Slack](https://join.slack.com/t/covid19datahub/shared_invite/zt-dld2grt2-vmso7HkI8yFabW5R_mAZJw) to get help
- Submit your pull request and earn a [badge](https://eu.badgr.com/public/badges/MC89IAjTTLGs3geP3xHjRw)

## R Package COVID19

Simple, yet effective R package to acquire tidy format datasets of the 2019 Novel Coronavirus COVID-19 (2019-nCoV) epidemic. The data are downloaded in real-time, cleaned and matched with exogenous variables.

### Quickstart

```R
# Install COVID19
install.packages("COVID19")

# Load COVID19
require("COVID19")
```
### Usage

```R
covid19(ISO = NULL, level = 1, start = "2019-01-01", end = Sys.Date(), vintage = FALSE, raw = FALSE, cache = TRUE)
```

### Arguments

| Argument    | Description                                                  |
| ----------- | ------------------------------------------------------------ |
| ```ISO```   | vector of ISO codes to retrieve (alpha-2, alpha-3 or numeric). Each country is identified by one of its [ISO codes](https://github.com/covid19datahub/COVID19/blob/master/inst/extdata/db/ISO.csv) |
| ```level``` | integer. Granularity level. 1: country-level data. 2: state-level data. 3: city-level data. |
| `start`     | the start date of the period of interest.                    |
| `end`       | the end date of the period of interest.                      |
| `vintage`   | logical. Retrieve the snapshot of the dataset at the `end` date instead of using the latest version? Default `FALSE`. |
| ```raw```   | logical. Skip data cleaning? Default `FALSE`.                |
| ```cache``` | logical. Memory caching? Significantly improves performance on successive calls. Default `TRUE`. |

### Details

The raw data are cleaned by filling missing dates with `NA` values. This ensures that all countries share the same grid of dates and no single day is skipped. Then, `NA` values are replaced with the previous non-`NA` value or `0` for the following variables:

- `deaths`, `confirmed`, `tests`, `recovered`, `icu`, `hosp`, `vent`
- `driving`, `walking`, `transit`

If no data is available at a granularity level (country/state) but is available at a lower level (state/city), the higher level data are obtained by aggregating the lower level data.

### Examples

```R
# Worldwide data by country
covid19()

# Worldwide data by state
covid19(level = 2)

# US data by state
covid19("USA", level = 2)

# Swiss data by state (cantons)
covid19("CHE", level = 2)

# Italian data by state (regions)
covid19("ITA", level = 2)

# Italian and US data by city
covid19(c("ITA","USA"), level = 3)
```

## Dataset

| Variable         | Description                                                  |
| ---------------- | ------------------------------------------------------------ |
| `id`             | location identifier.                                         |
| `date`           | observation time.                                            |
| `deaths`         | cumulative number of  deaths.                                |
| `confirmed`      | cumulative number of  confirmed cases.                       |
| `tests`          | cumulative number of  tests.                                 |
| `recovered`      | cumulative number of patients released from hospitals or reported recovered. |
| `hosp`           | number of hospitalized patients on date.                     |
| `icu`            | number of hospitalized patients in ICUs on date.             |
| `vent`           | number of patients requiring invasive ventilation on date.   |
| `driving`        | relative volume of (driving) directions requests compared to a baseline volume on January 13th, 2020. <https://www.apple.com/covid19/mobility> |
| `walking`        | relative volume of (walking) directions requests compared to a baseline volume on January 13th, 2020. <https://www.apple.com/covid19/mobility> |
| `transit`        | relative volume of (transit) directions requests compared to a baseline volume on January 13th, 2020. <https://www.apple.com/covid19/mobility> |
| `country`        | administrative area of top level.                            |
| `state`          | administrative area of a lower level, usually states, regions or cantons. |
| `city`           | administrative are of a lower level, usually cities or municipalities. |
| `lat`            | latitude.                                                    |
| `lng`            | longitude.                                                   |
| `pop`            | total population.                                            |
| `pop_14`         | population ages 0-14 (% of total population)<sup>*</sup>.    |
| `pop_15_64`      | population ages 15-64 (% of total population).<sup>**</sup>  |
| `pop_65`         | population ages 65+ (% of total population).                 |
| `pop_age`        | median age of population.                                    |
| `pop_density`    | population density per km<sup>2</sup>.                       |
| `pop_death_rate` | population mortality rate.                                   |

<sup>*</sup> _Switzerland: ages 0-19_

<sup>**</sup> _Switzerland: ages 20-64_

## CSV Data Files

CSV datasets of the 2019 Novel Coronavirus COVID-19 (2019-nCoV) epidemic. The files are generated with the [R package COVID19](https://cran.r-project.org/package=COVID19) and updated daily. 

__Clean data__

- <https://storage.covid19datahub.io/data-1.csv> (country-level)
- <https://storage.covid19datahub.io/data-2.csv> (state-level)
- <https://storage.covid19datahub.io/data-3.csv> (city-level)

__Raw data__

- <https://storage.covid19datahub.io/rawdata-1.csv> (country-level)
- <https://storage.covid19datahub.io/rawdata-2.csv> (state-level)
- <https://storage.covid19datahub.io/rawdata-3.csv> (city-level)

## Data coverage 

Help improve the data coverage and **add new countries and variables**. See [how to contribute](https://github.com/covid19datahub/COVID19/blob/master/CONTRIBUTING.md).

|                 |                            deaths                            |                          confirmed                           |                            tests                             |                          recovered                           |                             hosp                             |                             icu                              |                             vent                             |                           driving                            |                           walking                            |                           transit                            |                             lat                              |                             lng                              |                             pop                              |                            pop_14                            |                          pop_15_64                           |                            pop_65                            |                           pop_age                            |                         pop_density                          |                        pop_death_rate                        |
| --------------- | :----------------------------------------------------------: | :----------------------------------------------------------: | :----------------------------------------------------------: | :----------------------------------------------------------: | :----------------------------------------------------------: | :----------------------------------------------------------: | :----------------------------------------------------------: | :----------------------------------------------------------: | :----------------------------------------------------------: | :----------------------------------------------------------: | :----------------------------------------------------------: | :----------------------------------------------------------: | :----------------------------------------------------------: | :----------------------------------------------------------: | :----------------------------------------------------------: | :----------------------------------------------------------: | :----------------------------------------------------------: | :----------------------------------------------------------: | :----------------------------------------------------------: |
|                 |                          (coverage)                          |                          (coverage)                          |                          (coverage)                          |                          (coverage)                          |                          (coverage)                          |                          (coverage)                          |                          (coverage)                          |                          (coverage)                          |                          (coverage)                          |                          (coverage)                          |                          (coverage)                          |                          (coverage)                          |                          (coverage)                          |                          (coverage)                          |                          (coverage)                          |                          (coverage)                          |                          (coverage)                          |                          (coverage)                          |                          (coverage)                          |
| **World**       |                                                              |                                                              |                                                              |                                                              |                                                              |                                                              |                                                              |                                                              |                                                              |                                                              |                                                              |                                                              |                                                              |                                                              |                                                              |                                                              |                                                              |                                                              |                                                              |
| by country      | ![](https://storage.covid19datahub.io/coverage/deaths/WORLD.svg) | ![](https://storage.covid19datahub.io/coverage/confirmed/WORLD.svg) | ![](https://storage.covid19datahub.io/coverage/tests/WORLD.svg) | ![](https://storage.covid19datahub.io/coverage/recovered/WORLD.svg) | ![](https://storage.covid19datahub.io/coverage/hosp/WORLD.svg) | ![](https://storage.covid19datahub.io/coverage/icu/WORLD.svg) | ![](https://storage.covid19datahub.io/coverage/vent/WORLD.svg) | ![](https://storage.covid19datahub.io/coverage/driving/WORLD.svg) | ![](https://storage.covid19datahub.io/coverage/walking/WORLD.svg) | ![](https://storage.covid19datahub.io/coverage/transit/WORLD.svg) | ![](https://storage.covid19datahub.io/coverage/lat/WORLD.svg) | ![](https://storage.covid19datahub.io/coverage/lng/WORLD.svg) | ![](https://storage.covid19datahub.io/coverage/pop/WORLD.svg) | ![](https://storage.covid19datahub.io/coverage/pop_14/WORLD.svg) | ![](https://storage.covid19datahub.io/coverage/pop_15_64/WORLD.svg) | ![](https://storage.covid19datahub.io/coverage/pop_65/WORLD.svg) | ![](https://storage.covid19datahub.io/coverage/pop_age/WORLD.svg) | ![](https://storage.covid19datahub.io/coverage/pop_density/WORLD.svg) | ![](https://storage.covid19datahub.io/coverage/pop_death_rate/WORLD.svg) |
| **US**          |                                                              |                                                              |                                                              |                                                              |                                                              |                                                              |                                                              |                                                              |                                                              |                                                              |                                                              |                                                              |                                                              |                                                              |                                                              |                                                              |                                                              |                                                              |                                                              |
| by state        | ![](https://storage.covid19datahub.io/coverage/deaths/USA-2.svg) | ![](https://storage.covid19datahub.io/coverage/confirmed/USA-2.svg) | ![](https://storage.covid19datahub.io/coverage/tests/USA-2.svg) | ![](https://storage.covid19datahub.io/coverage/recovered/USA-2.svg) | ![](https://storage.covid19datahub.io/coverage/hosp/USA-2.svg) | ![](https://storage.covid19datahub.io/coverage/icu/USA-2.svg) | ![](https://storage.covid19datahub.io/coverage/vent/USA-2.svg) | ![](https://storage.covid19datahub.io/coverage/driving/USA-2.svg) | ![](https://storage.covid19datahub.io/coverage/walking/USA-2.svg) | ![](https://storage.covid19datahub.io/coverage/transit/USA-2.svg) | ![](https://storage.covid19datahub.io/coverage/lat/USA-2.svg) | ![](https://storage.covid19datahub.io/coverage/lng/USA-2.svg) | ![](https://storage.covid19datahub.io/coverage/pop/USA-2.svg) | ![](https://storage.covid19datahub.io/coverage/pop_14/USA-2.svg) | ![](https://storage.covid19datahub.io/coverage/pop_15_64/USA-2.svg) | ![](https://storage.covid19datahub.io/coverage/pop_65/USA-2.svg) | ![](https://storage.covid19datahub.io/coverage/pop_age/USA-2.svg) | ![](https://storage.covid19datahub.io/coverage/pop_density/USA-2.svg) | ![](https://storage.covid19datahub.io/coverage/pop_death_rate/USA-2.svg) |
| by city         | ![](https://storage.covid19datahub.io/coverage/deaths/USA-3.svg) | ![](https://storage.covid19datahub.io/coverage/confirmed/USA-3.svg) | ![](https://storage.covid19datahub.io/coverage/tests/USA-3.svg) | ![](https://storage.covid19datahub.io/coverage/recovered/USA-3.svg) | ![](https://storage.covid19datahub.io/coverage/hosp/USA-3.svg) | ![](https://storage.covid19datahub.io/coverage/icu/USA-3.svg) | ![](https://storage.covid19datahub.io/coverage/vent/USA-3.svg) | ![](https://storage.covid19datahub.io/coverage/driving/USA-3.svg) | ![](https://storage.covid19datahub.io/coverage/walking/USA-3.svg) | ![](https://storage.covid19datahub.io/coverage/transit/USA-3.svg) | ![](https://storage.covid19datahub.io/coverage/lat/USA-3.svg) | ![](https://storage.covid19datahub.io/coverage/lng/USA-3.svg) | ![](https://storage.covid19datahub.io/coverage/pop/USA-3.svg) | ![](https://storage.covid19datahub.io/coverage/pop_14/USA-3.svg) | ![](https://storage.covid19datahub.io/coverage/pop_15_64/USA-3.svg) | ![](https://storage.covid19datahub.io/coverage/pop_65/USA-3.svg) | ![](https://storage.covid19datahub.io/coverage/pop_age/USA-3.svg) | ![](https://storage.covid19datahub.io/coverage/pop_density/USA-3.svg) | ![](https://storage.covid19datahub.io/coverage/pop_death_rate/USA-3.svg) |
| __Italy__       |                                                              |                                                              |                                                              |                                                              |                                                              |                                                              |                                                              |                                                              |                                                              |                                                              |                                                              |                                                              |                                                              |                                                              |                                                              |                                                              |                                                              |                                                              |                                                              |
| by region       | ![](https://storage.covid19datahub.io/coverage/deaths/ITA-2.svg) | ![](https://storage.covid19datahub.io/coverage/confirmed/ITA-2.svg) | ![](https://storage.covid19datahub.io/coverage/tests/ITA-2.svg) | ![](https://storage.covid19datahub.io/coverage/recovered/ITA-2.svg) | ![](https://storage.covid19datahub.io/coverage/hosp/ITA-2.svg) | ![](https://storage.covid19datahub.io/coverage/icu/ITA-2.svg) | ![](https://storage.covid19datahub.io/coverage/vent/ITA-2.svg) | ![](https://storage.covid19datahub.io/coverage/driving/ITA-2.svg) | ![](https://storage.covid19datahub.io/coverage/walking/ITA-2.svg) | ![](https://storage.covid19datahub.io/coverage/transit/ITA-2.svg) | ![](https://storage.covid19datahub.io/coverage/lat/ITA-2.svg) | ![](https://storage.covid19datahub.io/coverage/lng/ITA-2.svg) | ![](https://storage.covid19datahub.io/coverage/pop/ITA-2.svg) | ![](https://storage.covid19datahub.io/coverage/pop_14/ITA-2.svg) | ![](https://storage.covid19datahub.io/coverage/pop_15_64/ITA-2.svg) | ![](https://storage.covid19datahub.io/coverage/pop_65/ITA-2.svg) | ![](https://storage.covid19datahub.io/coverage/pop_age/ITA-2.svg) | ![](https://storage.covid19datahub.io/coverage/pop_density/ITA-2.svg) | ![](https://storage.covid19datahub.io/coverage/pop_death_rate/ITA-2.svg) |
| by city         | ![](https://storage.covid19datahub.io/coverage/deaths/ITA-3.svg) | ![](https://storage.covid19datahub.io/coverage/confirmed/ITA-3.svg) | ![](https://storage.covid19datahub.io/coverage/tests/ITA-3.svg) | ![](https://storage.covid19datahub.io/coverage/recovered/ITA-3.svg) | ![](https://storage.covid19datahub.io/coverage/hosp/ITA-3.svg) | ![](https://storage.covid19datahub.io/coverage/icu/ITA-3.svg) | ![](https://storage.covid19datahub.io/coverage/vent/ITA-3.svg) | ![](https://storage.covid19datahub.io/coverage/driving/ITA-3.svg) | ![](https://storage.covid19datahub.io/coverage/walking/ITA-3.svg) | ![](https://storage.covid19datahub.io/coverage/transit/ITA-3.svg) | ![](https://storage.covid19datahub.io/coverage/lat/ITA-3.svg) | ![](https://storage.covid19datahub.io/coverage/lng/ITA-3.svg) | ![](https://storage.covid19datahub.io/coverage/pop/ITA-3.svg) | ![](https://storage.covid19datahub.io/coverage/pop_14/ITA-3.svg) | ![](https://storage.covid19datahub.io/coverage/pop_15_64/ITA-3.svg) | ![](https://storage.covid19datahub.io/coverage/pop_65/ITA-3.svg) | ![](https://storage.covid19datahub.io/coverage/pop_age/ITA-3.svg) | ![](https://storage.covid19datahub.io/coverage/pop_density/ITA-3.svg) | ![](https://storage.covid19datahub.io/coverage/pop_death_rate/ITA-3.svg) |
| **Switzerland** |                                                              |                                                              |                                                              |                                                              |                                                              |                                                              |                                                              |                                                              |                                                              |                                                              |                                                              |                                                              |                                                              |                                                              |                                                              |                                                              |                                                              |                                                              |                                                              |
| by canton       | ![](https://storage.covid19datahub.io/coverage/deaths/CHE-2.svg) | ![](https://storage.covid19datahub.io/coverage/confirmed/CHE-2.svg) | ![](https://storage.covid19datahub.io/coverage/tests/CHE-2.svg) | ![](https://storage.covid19datahub.io/coverage/recovered/CHE-2.svg) | ![](https://storage.covid19datahub.io/coverage/hosp/CHE-2.svg) | ![](https://storage.covid19datahub.io/coverage/icu/CHE-2.svg) | ![](https://storage.covid19datahub.io/coverage/vent/CHE-2.svg) | ![](https://storage.covid19datahub.io/coverage/driving/CHE-2.svg) | ![](https://storage.covid19datahub.io/coverage/walking/CHE-2.svg) | ![](https://storage.covid19datahub.io/coverage/transit/CHE-2.svg) | ![](https://storage.covid19datahub.io/coverage/lat/CHE-2.svg) | ![](https://storage.covid19datahub.io/coverage/lng/CHE-2.svg) | ![](https://storage.covid19datahub.io/coverage/pop/CHE-2.svg) | ![](https://storage.covid19datahub.io/coverage/pop_14/CHE-2.svg) | ![](https://storage.covid19datahub.io/coverage/pop_15_64/CHE-2.svg) | ![](https://storage.covid19datahub.io/coverage/pop_65/CHE-2.svg) | ![](https://storage.covid19datahub.io/coverage/pop_age/CHE-2.svg) | ![](https://storage.covid19datahub.io/coverage/pop_density/CHE-2.svg) | ![](https://storage.covid19datahub.io/coverage/pop_death_rate/CHE-2.svg) |
| **Canada**      |                                                              |                                                              |                                                              |                                                              |                                                              |                                                              |                                                              |                                                              |                                                              |                                                              |                                                              |                                                              |                                                              |                                                              |                                                              |                                                              |                                                              |                                                              |                                                              |
| by state       | ![](https://storage.covid19datahub.io/coverage/deaths/CAN-2.svg) | ![](https://storage.covid19datahub.io/coverage/confirmed/CAN-2.svg) | ![](https://storage.covid19datahub.io/coverage/tests/CAN-2.svg) | ![](https://storage.covid19datahub.io/coverage/recovered/CAN-2.svg) | ![](https://storage.covid19datahub.io/coverage/hosp/CAN-2.svg) | ![](https://storage.covid19datahub.io/coverage/icu/CAN-2.svg) | ![](https://storage.covid19datahub.io/coverage/vent/CAN-2.svg) | ![](https://storage.covid19datahub.io/coverage/driving/CAN-2.svg) | ![](https://storage.covid19datahub.io/coverage/walking/CAN-2.svg) | ![](https://storage.covid19datahub.io/coverage/transit/CAN-2.svg) | ![](https://storage.covid19datahub.io/coverage/lat/CAN-2.svg) | ![](https://storage.covid19datahub.io/coverage/lng/CAN-2.svg) | ![](https://storage.covid19datahub.io/coverage/pop/CAN-2.svg) | ![](https://storage.covid19datahub.io/coverage/pop_14/CAN-2.svg) | ![](https://storage.covid19datahub.io/coverage/pop_15_64/CAN-2.svg) | ![](https://storage.covid19datahub.io/coverage/pop_65/CAN-2.svg) | ![](https://storage.covid19datahub.io/coverage/pop_age/CAN-2.svg) | ![](https://storage.covid19datahub.io/coverage/pop_density/CAN-2.svg) | ![](https://storage.covid19datahub.io/coverage/pop_death_rate/CAN-2.svg) |
| **Sweden**      |                                                              |                                                              |                                                              |                                                              |                                                              |                                                              |                                                              |                                                              |                                                              |                                                              |                                                              |                                                              |                                                              |                                                              |                                                              |                                                              |                                                              |                                                              |                                                              |
| by country       | ![](https://storage.covid19datahub.io/coverage/deaths/SWE-1.svg) | ![](https://storage.covid19datahub.io/coverage/confirmed/SWE-1.svg) | ![](https://storage.covid19datahub.io/coverage/tests/SWE-1.svg) | ![](https://storage.covid19datahub.io/coverage/recovered/SWE-1.svg) | ![](https://storage.covid19datahub.io/coverage/hosp/SWE-1.svg) | ![](https://storage.covid19datahub.io/coverage/icu/SWE-1.svg) | ![](https://storage.covid19datahub.io/coverage/vent/SWE-1.svg) | ![](https://storage.covid19datahub.io/coverage/driving/SWE-1.svg) | ![](https://storage.covid19datahub.io/coverage/walking/SWE-1.svg) | ![](https://storage.covid19datahub.io/coverage/transit/SWE-1.svg) | ![](https://storage.covid19datahub.io/coverage/lat/SWE-1.svg) | ![](https://storage.covid19datahub.io/coverage/lng/SWE-1.svg) | ![](https://storage.covid19datahub.io/coverage/pop/SWE-1.svg) | ![](https://storage.covid19datahub.io/coverage/pop_14/SWE-1.svg) | ![](https://storage.covid19datahub.io/coverage/pop_15_64/SWE-1.svg) | ![](https://storage.covid19datahub.io/coverage/pop_65/SWE-1.svg) | ![](https://storage.covid19datahub.io/coverage/pop_age/SWE-1.svg) | ![](https://storage.covid19datahub.io/coverage/pop_density/SWE-1.svg) | ![](https://storage.covid19datahub.io/coverage/pop_death_rate/SWE-1.svg) |
| by state       | ![](https://storage.covid19datahub.io/coverage/deaths/SWE-2.svg) | ![](https://storage.covid19datahub.io/coverage/confirmed/SWE-2.svg) | ![](https://storage.covid19datahub.io/coverage/tests/SWE-2.svg) | ![](https://storage.covid19datahub.io/coverage/recovered/SWE-2.svg) | ![](https://storage.covid19datahub.io/coverage/hosp/SWE-2.svg) | ![](https://storage.covid19datahub.io/coverage/icu/SWE-2.svg) | ![](https://storage.covid19datahub.io/coverage/vent/SWE-2.svg) | ![](https://storage.covid19datahub.io/coverage/driving/SWE-2.svg) | ![](https://storage.covid19datahub.io/coverage/walking/SWE-2.svg) | ![](https://storage.covid19datahub.io/coverage/transit/SWE-2.svg) | ![](https://storage.covid19datahub.io/coverage/lat/SWE-2.svg) | ![](https://storage.covid19datahub.io/coverage/lng/SWE-2.svg) | ![](https://storage.covid19datahub.io/coverage/pop/SWE-2.svg) | ![](https://storage.covid19datahub.io/coverage/pop_14/SWE-2.svg) | ![](https://storage.covid19datahub.io/coverage/pop_15_64/SWE-2.svg) | ![](https://storage.covid19datahub.io/coverage/pop_65/SWE-2.svg) | ![](https://storage.covid19datahub.io/coverage/pop_age/SWE-2.svg) | ![](https://storage.covid19datahub.io/coverage/pop_density/SWE-2.svg) | ![](https://storage.covid19datahub.io/coverage/pop_death_rate/SWE-2.svg) |
| **Czech Republic**      |                                                              |                                                              |                                                              |                                                              |                                                              |                                                              |                                                              |                                                              |                                                              |                                                              |                                                              |                                                              |                                                              |                                                              |                                                              |                                                              |                                                              |                                                              |                                                              |
| by country       | ![](https://storage.covid19datahub.io/coverage/deaths/CZE-1.svg) | ![](https://storage.covid19datahub.io/coverage/confirmed/CZE-1.svg) | ![](https://storage.covid19datahub.io/coverage/tests/CZE-1.svg) | ![](https://storage.covid19datahub.io/coverage/recovered/CZE-1.svg) | ![](https://storage.covid19datahub.io/coverage/hosp/CZE-1.svg) | ![](https://storage.covid19datahub.io/coverage/icu/CZE-1.svg) | ![](https://storage.covid19datahub.io/coverage/vent/CZE-1.svg) | ![](https://storage.covid19datahub.io/coverage/driving/CZE-1.svg) | ![](https://storage.covid19datahub.io/coverage/walking/CZE-1.svg) | ![](https://storage.covid19datahub.io/coverage/transit/CZE-1.svg) | ![](https://storage.covid19datahub.io/coverage/lat/CZE-1.svg) | ![](https://storage.covid19datahub.io/coverage/lng/CZE-1.svg) | ![](https://storage.covid19datahub.io/coverage/pop/CZE-1.svg) | ![](https://storage.covid19datahub.io/coverage/pop_14/CZE-1.svg) | ![](https://storage.covid19datahub.io/coverage/pop_15_64/CZE-1.svg) | ![](https://storage.covid19datahub.io/coverage/pop_65/CZE-1.svg) | ![](https://storage.covid19datahub.io/coverage/pop_age/CZE-1.svg) | ![](https://storage.covid19datahub.io/coverage/pop_density/CZE-1.svg) | ![](https://storage.covid19datahub.io/coverage/pop_death_rate/CZE-1.svg) |


## Data sources 

The following sources are gratefully acknowledged for making the data available to the public.

|                    | deaths                                                       | confirmed                                                    | tests                                                        | recovered                                                    | hosp                                                         | icu                                                          | vent                                                       | driving                                                      | walking                                                      | transit                                                      | lat                                                          | lng                                                          | pop                                                          | pop_14                                                       | pop_15_64                                                    | pop_65                                                       | pop_age                                                      | pop_density                                                  | pop_death_rate                                               |
| ------------------ | ------------------------------------------------------------ | ------------------------------------------------------------ | ------------------------------------------------------------ | ------------------------------------------------------------ | ------------------------------------------------------------ | ------------------------------------------------------------ | ---------------------------------------------------------- | ------------------------------------------------------------ | ------------------------------------------------------------ | ------------------------------------------------------------ | ------------------------------------------------------------ | ------------------------------------------------------------ | ------------------------------------------------------------ | ------------------------------------------------------------ | ------------------------------------------------------------ | ------------------------------------------------------------ | ------------------------------------------------------------ | ------------------------------------------------------------ | ------------------------------------------------------------ |
| **World**          |                                                              |                                                              |                                                              |                                                              |                                                              |                                                              |                                                            |                                                              |                                                              |                                                              |                                                              |                                                              |                                                              |                                                              |                                                              |                                                              |                                                              |                                                              |                                                              |
| by country         | [Center For Systems Science and Engineering at JHU](https://github.com/CSSEGISandData/COVID-19) | [Center For Systems Science and Engineering at JHU](https://github.com/CSSEGISandData/COVID-19) |                                                              | [Center For Systems Science and Engineering at JHU](https://github.com/CSSEGISandData/COVID-19) |                                                              |                                                              |                                                            | [Apple mobility trends](https://www.apple.com/covid19/mobility) | [Apple mobility trends](https://www.apple.com/covid19/mobility) | [Apple mobility trends](https://www.apple.com/covid19/mobility) | [Center For Systems Science and Engineering at JHU](https://github.com/CSSEGISandData/COVID-19) | [Center For Systems Science and Engineering at JHU](https://github.com/CSSEGISandData/COVID-19) | [World Bank Open Data (2018)](https://data.worldbank.org/)   | [World Bank Open Data (2018)](https://data.worldbank.org/)   | [World Bank Open Data (2018)](https://data.worldbank.org/)   | [World Bank Open Data (2018)](https://data.worldbank.org/)   | [World Factbook by CIA (2018)](https://www.cia.gov/library/publications/resources/the-world-factbook/fields/343rank.html) | [World Bank Open Data (2018)](https://data.worldbank.org/)   | [World Bank Open Data (2018)](https://data.worldbank.org/)   |
| **US**             |                                                              |                                                              |                                                              |                                                              |                                                              |                                                              |                                                            |                                                              |                                                              |                                                              |                                                              |                                                              |                                                              |                                                              |                                                              |                                                              |                                                              |                                                              |                                                              |
| by state           | [Center For Systems Science and Engineering at JHU](https://github.com/CSSEGISandData/COVID-19) | [Center For Systems Science and Engineering at JHU](https://github.com/CSSEGISandData/COVID-19) |                                                              |                                                              |                                                              |                                                              |                                                            |                                                              |                                                              |                                                              | [Center For Systems Science and Engineering at JHU](https://github.com/CSSEGISandData/COVID-19) | [Center For Systems Science and Engineering at JHU](https://github.com/CSSEGISandData/COVID-19) | [Center For Systems Science and Engineering at JHU](https://github.com/CSSEGISandData/COVID-19) |                                                              |                                                              |                                                              |                                                              |                                                              |                                                              |
| by city            | [Center For Systems Science and Engineering at JHU](https://github.com/CSSEGISandData/COVID-19) | [Center For Systems Science and Engineering at JHU](https://github.com/CSSEGISandData/COVID-19) |                                                              |                                                              |                                                              |                                                              |                                                            |                                                              |                                                              |                                                              | [Center For Systems Science and Engineering at JHU](https://github.com/CSSEGISandData/COVID-19) | [Center For Systems Science and Engineering at JHU](https://github.com/CSSEGISandData/COVID-19) | [Center For Systems Science and Engineering at JHU](https://github.com/CSSEGISandData/COVID-19) |                                                              |                                                              |                                                              |                                                              |                                                              |                                                              |
| __Italy__          |                                                              |                                                              |                                                              |                                                              |                                                              |                                                              |                                                            |                                                              |                                                              |                                                              |                                                              |                                                              |                                                              |                                                              |                                                              |                                                              |                                                              |                                                              |                                                              |
| by region          | [Ministero della Salute](https://github.com/pcm-dpc/COVID-19) | [Ministero della Salute](https://github.com/pcm-dpc/COVID-19) | [Ministero della Salute](https://github.com/pcm-dpc/COVID-19) | [Ministero della Salute](https://github.com/pcm-dpc/COVID-19) | [Ministero della Salute](https://github.com/pcm-dpc/COVID-19) | [Ministero della Salute](https://github.com/pcm-dpc/COVID-19) |                                                            |                                                              |                                                              |                                                              | [Istituto Nazionale di Statistica (2018)](https://www.istat.it/en/population-and-households?data-and-indicators) | [Istituto Nazionale di Statistica (2018)](https://www.istat.it/en/population-and-households?data-and-indicators) | [Istituto Nazionale di Statistica (2018)](https://www.istat.it/en/population-and-households?data-and-indicators) | [Istituto Nazionale di Statistica (2018)](https://www.istat.it/en/population-and-households?data-and-indicators) | [Istituto Nazionale di Statistica (2018)](https://www.istat.it/en/population-and-households?data-and-indicators) | [Istituto Nazionale di Statistica (2018)](https://www.istat.it/en/population-and-households?data-and-indicators) | [Istituto Nazionale di Statistica (2018)](https://www.istat.it/en/population-and-households?data-and-indicators) | [Istituto Nazionale di Statistica (2018)](https://www.istat.it/en/population-and-households?data-and-indicators) | [Istituto Nazionale di Statistica (2018)](https://www.istat.it/en/population-and-households?data-and-indicators) |
| by city            |                                                              | [Ministero della Salute](https://github.com/pcm-dpc/COVID-19) |                                                              |                                                              |                                                              |                                                              |                                                            |                                                              |                                                              |                                                              | [Istituto Nazionale di Statistica (2018)](https://www.istat.it/en/population-and-households?data-and-indicators) | [Istituto Nazionale di Statistica (2018)](https://www.istat.it/en/population-and-households?data-and-indicators) | [Istituto Nazionale di Statistica (2018)](https://www.istat.it/en/population-and-households?data-and-indicators) | [Istituto Nazionale di Statistica (2018)](https://www.istat.it/en/population-and-households?data-and-indicators) | [Istituto Nazionale di Statistica (2018)](https://www.istat.it/en/population-and-households?data-and-indicators) | [Istituto Nazionale di Statistica (2018)](https://www.istat.it/en/population-and-households?data-and-indicators) | [Istituto Nazionale di Statistica (2018)](https://www.istat.it/en/population-and-households?data-and-indicators) | [Istituto Nazionale di Statistica (2018)](https://www.istat.it/en/population-and-households?data-and-indicators) | [Istituto Nazionale di Statistica (2018)](https://www.istat.it/en/population-and-households?data-and-indicators) |
| **Switzerland**    |                                                              |                                                              |                                                              |                                                              |                                                              |                                                              |                                                            |                                                              |                                                              |                                                              |                                                              |                                                              |                                                              |                                                              |                                                              |                                                              |                                                              |                                                              |                                                              |
| by canton          | [Open Government Data](https://github.com/openZH/covid_19)   | [Open Government Data](https://github.com/openZH/covid_19)   | [Open Government Data](https://github.com/openZH/covid_19)   | [Open Government Data](https://github.com/openZH/covid_19)   | [Open Government Data](https://github.com/openZH/covid_19)   | [Open Government Data](https://github.com/openZH/covid_19)   | [Open Government Data](https://github.com/openZH/covid_19) |                                                              |                                                              |                                                              | [Swiss Federal Statistical Office (2018)](https://www.bfs.admin.ch/bfs/en/home/statistics/regional-statistics/regional-portraits-key-figures/cantons/data-explanations.html) | [Swiss Federal Statistical Office (2018)](https://www.bfs.admin.ch/bfs/en/home/statistics/regional-statistics/regional-portraits-key-figures/cantons/data-explanations.html) | [Swiss Federal Statistical Office (2018)](https://www.bfs.admin.ch/bfs/en/home/statistics/regional-statistics/regional-portraits-key-figures/cantons/data-explanations.html) | [Swiss Federal Statistical Office (2018)](https://www.bfs.admin.ch/bfs/en/home/statistics/regional-statistics/regional-portraits-key-figures/cantons/data-explanations.html) | [Swiss Federal Statistical Office (2018)](https://www.bfs.admin.ch/bfs/en/home/statistics/regional-statistics/regional-portraits-key-figures/cantons/data-explanations.html) | [Swiss Federal Statistical Office (2018)](https://www.bfs.admin.ch/bfs/en/home/statistics/regional-statistics/regional-portraits-key-figures/cantons/data-explanations.html) | [Swiss Federal Statistical Office (2018)](https://www.bfs.admin.ch/bfs/en/home/statistics/regional-statistics/regional-portraits-key-figures/cantons/data-explanations.html) | [Swiss Federal Statistical Office (2018)](https://www.bfs.admin.ch/bfs/en/home/statistics/regional-statistics/regional-portraits-key-figures/cantons/data-explanations.html) | [Swiss Federal Statistical Office (2018)](https://www.bfs.admin.ch/bfs/en/home/statistics/regional-statistics/regional-portraits-key-figures/cantons/data-explanations.html) |
| **Canada**         |                                                              |                                                              |                                                              |                                                              |                                                              |                                                              |                                                            |                                                              |                                                              |                                                              |                                                              |                                                              |                                                              |                                                              |                                                              |                                                              |                                                              |                                                              |                                                              |
| by state           | [Center For Systems Science and Engineering at JHU](https://github.com/CSSEGISandData/COVID-19) | [Center For Systems Science and Engineering at JHU](https://github.com/CSSEGISandData/COVID-19) |                                                              |                                                              |                                                              |                                                              |                                                            |                                                              |                                                              |                                                              |                                                              |                                                              | [Canada's National Statistical Agency (2020 Q1)](https://www150.statcan.gc.ca/t1/tbl1/en/tv.action?pid=1710000901) |                                                              |                                                              |                                                              |                                                              |                                                              |                                                              |
| **Sweden**         |                                                              |                                                              |                                                              |                                                              |                                                              |                                                              |                                                            |                                                              |                                                              |                                                              |                                                              |                                                              |                                                              |                                                              |                                                              |                                                              |                                                              |                                                              |                                                              |
| by country         | [Public Health Agency, Sweden](https://oppnadata.se/datamangd/#esc_entry=1424&esc_context=525) | [Public Health Agency, Sweden](https://oppnadata.se/datamangd/#esc_entry=1424&esc_context=525) |                                                              |                                                              |                                                              | [Public Health Agency, Sweden](https://oppnadata.se/datamangd/#esc_entry=1424&esc_context=525) |                                                            |                                                              |                                                              |                                                              | [Center For Systems Science and Engineering at JHU](https://github.com/CSSEGISandData/COVID-19) | [Center For Systems Science and Engineering at JHU](https://github.com/CSSEGISandData/COVID-19) | [World Bank Open Data (2018)](https://data.worldbank.org/)   | [World Bank Open Data (2018)](https://data.worldbank.org/)   | [World Bank Open Data (2018)](https://data.worldbank.org/)   | [World Bank Open Data (2018)](https://data.worldbank.org/)   | [World Factbook by CIA (2018)](https://www.cia.gov/library/publications/resources/the-world-factbook/fields/343rank.html) | [World Bank Open Data (2018)](https://data.worldbank.org/)   | [World Bank Open Data (2018)](https://data.worldbank.org/)   |
| by state           |                                                              | [Public Health Agency, Sweden](https://oppnadata.se/datamangd/#esc_entry=1424&esc_context=525) |                                                              |                                                              |                                                              |                                                              |                                                            |                                                              |                                                              |                                                              |                                                              |                                                              |                                                              |                                                              |                                                              |                                                              |                                                              |                                                              |                                                              |
| **Czech Republic** |                                                              |                                                              |                                                              |                                                              |                                                              |                                                              |                                                            |                                                              |                                                              |                                                              |                                                              |                                                              |                                                              |                                                              |                                                              |                                                              |                                                              |                                                              |                                                              |
| by country         |                                                              | [Ministery of Health of Czech Republic](https://onemocneni-aktualne.mzcr.cz/) | [Ministery of Health of Czech Republic](https://onemocneni-aktualne.mzcr.cz/) |                                                              |                                                              |                                                              |                                                            |                                                              |                                                              |                                                              |                                                              |                                                              |                                                              |                                                              |                                                              |                                                              |                                                              |                                                              |                                                              |

### Acknowledgements 

The following people have contributed to the data collection as a joint effort against COVID-19.

|                    | deaths                                        | confirmed                                     | tests                                         | recovered                           | hosp                                | icu                                           | vent                                | driving                             | walking                             | transit                             | lat                                 | lng                                 | pop                                        | pop_14                              | pop_15_64                           | pop_65                              | pop_age                             | pop_density                         | pop_death_rate                      |
| ------------------ | --------------------------------------------- | --------------------------------------------- | --------------------------------------------- | ----------------------------------- | ----------------------------------- | --------------------------------------------- | ----------------------------------- | ----------------------------------- | ----------------------------------- | ----------------------------------- | ----------------------------------- | ----------------------------------- | ------------------------------------------ | ----------------------------------- | ----------------------------------- | ----------------------------------- | ----------------------------------- | ----------------------------------- | ----------------------------------- |
| **World**          |                                               |                                               |                                               |                                     |                                     |                                               |                                     |                                     |                                     |                                     |                                     |                                     |                                            |                                     |                                     |                                     |                                     |                                     |                                     |
| by country         | [E.Guidotti](https://guidotti.dev/)           | [E.Guidotti](https://guidotti.dev/)           |                                               | [E.Guidotti](https://guidotti.dev/) |                                     |                                               |                                     | [E.Guidotti](https://guidotti.dev/) | [E.Guidotti](https://guidotti.dev/) | [E.Guidotti](https://guidotti.dev/) | [E.Guidotti](https://guidotti.dev/) | [E.Guidotti](https://guidotti.dev/) | [E.Guidotti](https://guidotti.dev/)        | [E.Guidotti](https://guidotti.dev/) | [E.Guidotti](https://guidotti.dev/) | [E.Guidotti](https://guidotti.dev/) | [E.Guidotti](https://guidotti.dev/) | [E.Guidotti](https://guidotti.dev/) | [E.Guidotti](https://guidotti.dev/) |
| **US**             |                                               |                                               |                                               |                                     |                                     |                                               |                                     |                                     |                                     |                                     |                                     |                                     |                                            |                                     |                                     |                                     |                                     |                                     |                                     |
| by state           | [E.Guidotti](https://guidotti.dev/)           | [E.Guidotti](https://guidotti.dev/)           |                                               |                                     |                                     |                                               |                                     |                                     |                                     |                                     | [E.Guidotti](https://guidotti.dev/) | [E.Guidotti](https://guidotti.dev/) | [E.Guidotti](https://guidotti.dev/)        |                                     |                                     |                                     |                                     |                                     |                                     |
| by city            | [E.Guidotti](https://guidotti.dev/)           | [E.Guidotti](https://guidotti.dev/)           |                                               |                                     |                                     |                                               |                                     |                                     |                                     |                                     | [E.Guidotti](https://guidotti.dev/) | [E.Guidotti](https://guidotti.dev/) | [E.Guidotti](https://guidotti.dev/)        |                                     |                                     |                                     |                                     |                                     |                                     |
| __Italy__          |                                               |                                               |                                               |                                     |                                     |                                               |                                     |                                     |                                     |                                     |                                     |                                     |                                            |                                     |                                     |                                     |                                     |                                     |                                     |
| by region          | [E.Guidotti](https://guidotti.dev/)           | [E.Guidotti](https://guidotti.dev/)           | [E.Guidotti](https://guidotti.dev/)           | [E.Guidotti](https://guidotti.dev/) | [E.Guidotti](https://guidotti.dev/) | [E.Guidotti](https://guidotti.dev/)           |                                     |                                     |                                     |                                     | [E.Guidotti](https://guidotti.dev/) | [E.Guidotti](https://guidotti.dev/) | [E.Guidotti](https://guidotti.dev/)        | [E.Guidotti](https://guidotti.dev/) | [E.Guidotti](https://guidotti.dev/) | [E.Guidotti](https://guidotti.dev/) | [E.Guidotti](https://guidotti.dev/) | [E.Guidotti](https://guidotti.dev/) | [E.Guidotti](https://guidotti.dev/) |
| by city            |                                               | [E.Guidotti](https://guidotti.dev/)           |                                               |                                     |                                     |                                               |                                     |                                     |                                     |                                     | [E.Guidotti](https://guidotti.dev/) | [E.Guidotti](https://guidotti.dev/) | [E.Guidotti](https://guidotti.dev/)        | [E.Guidotti](https://guidotti.dev/) | [E.Guidotti](https://guidotti.dev/) | [E.Guidotti](https://guidotti.dev/) | [E.Guidotti](https://guidotti.dev/) | [E.Guidotti](https://guidotti.dev/) | [E.Guidotti](https://guidotti.dev/) |
| **Switzerland**    |                                               |                                               |                                               |                                     |                                     |                                               |                                     |                                     |                                     |                                     |                                     |                                     |                                            |                                     |                                     |                                     |                                     |                                     |                                     |
| by canton          | [E.Guidotti](https://guidotti.dev/)           | [E.Guidotti](https://guidotti.dev/)           | [E.Guidotti](https://guidotti.dev/)           | [E.Guidotti](https://guidotti.dev/) | [E.Guidotti](https://guidotti.dev/) | [E.Guidotti](https://guidotti.dev/)           | [E.Guidotti](https://guidotti.dev/) |                                     |                                     |                                     | [E.Guidotti](https://guidotti.dev/) | [E.Guidotti](https://guidotti.dev/) | [E.Guidotti](https://guidotti.dev/)        | [E.Guidotti](https://guidotti.dev/) | [E.Guidotti](https://guidotti.dev/) | [E.Guidotti](https://guidotti.dev/) | [E.Guidotti](https://guidotti.dev/) | [E.Guidotti](https://guidotti.dev/) | [E.Guidotti](https://guidotti.dev/) |
| **Canada**         |                                               |                                               |                                               |                                     |                                     |                                               |                                     |                                     |                                     |                                     |                                     |                                     |                                            |                                     |                                     |                                     |                                     |                                     |                                     |
| by state           | [E.Guidotti](https://guidotti.dev/)           | [E.Guidotti](https://guidotti.dev/)           |                                               |                                     |                                     |                                               |                                     |                                     |                                     |                                     |                                     |                                     | [Dan Kelley](https://github.com/dankelley) |                                     |                                     |                                     |                                     |                                     |                                     |
| **Sweden**         |                                               |                                               |                                               |                                     |                                     |                                               |                                     |                                     |                                     |                                     |                                     |                                     |                                            |                                     |                                     |                                     |                                     |                                     |                                     |
| by country         | [M.Benes](https://github.com/martinbenes1996) | [M.Benes](https://github.com/martinbenes1996) |                                               |                                     |                                     | [M.Benes](https://github.com/martinbenes1996) |                                     |                                     |                                     |                                     | [E.Guidotti](https://guidotti.dev/) | [E.Guidotti](https://guidotti.dev/) | [E.Guidotti](https://guidotti.dev/)        | [E.Guidotti](https://guidotti.dev/) | [E.Guidotti](https://guidotti.dev/) | [E.Guidotti](https://guidotti.dev/) | [E.Guidotti](https://guidotti.dev/) | [E.Guidotti](https://guidotti.dev/) | [E.Guidotti](https://guidotti.dev/) |
| by state           |                                               | [M.Benes](https://github.com/martinbenes1996) |                                               |                                     |                                     |                                               |                                     |                                     |                                     |                                     |                                     |                                     |                                            |                                     |                                     |                                     |                                     |                                     |                                     |
| **Czech Republic** |                                               |                                               |                                               |                                     |                                     |                                               |                                     |                                     |                                     |                                     |                                     |                                     |                                            |                                     |                                     |                                     |                                     |                                     |                                     |
| by country         |                                               | [M.Benes](https://github.com/martinbenes1996) | [M.Benes](https://github.com/martinbenes1996) |                                     |                                     |                                               |                                     |                                     |                                     |                                     |                                     |                                     |                                            |                                     |                                     |                                     |                                     |                                     |                                     |

## Use Cases

- [Monitoring the advancement of the COVID–19 contagion in the regions of Italy](https://github.com/krzbar/COVID19)
- [Covid19 Incidence History](http://emit.phys.ocean.dal.ca/~kelley/covid19/)

## Terms of Use and Disclaimer

We have invested a lot of time and effort in creating [COVID-19 Data Hub](https://covid19datahub.io/). We expect you to agree to the following rules when using it: 

1. cite [Guidotti and Ardia (2020)](https://doi.org/10.13140/RG.2.2.11649.81763) in working papers and published papers that use [COVID-19 Data Hub](https://covid19datahub.io/)
2. place the URL [https://covid19datahub.io](https://covid19datahub.io) in a footnote to help others find [COVID-19 Data Hub](https://covid19datahub.io/) 
3. you assume full risk for the use of [COVID-19 Data Hub](https://covid19datahub.io/).

The [COVID-19 Data Hub](https://covid19datahub.io/) (R package COVID19, GitHub repo, cloud storage), and its contents herein, including all data, mapping, and analyses, are provided to the public strictly for educational and academic research purposes. The [COVID-19 Data Hub](https://covid19datahub.io/) relies upon publicly available data from multiple sources. We are currently in the process of reconciling the providers with proper reference to their open-source data. Please inform us if you see any issues with the data licenses.

We try our best to guarantee the data quality and consistency and the continuous filling of the [COVID-19 Data Hub](https://covid19datahub.io/). However, it is free software and comes with ABSOLUTELY NO WARRANTY. We hereby disclaim any and all representations and warranties with respect to the [COVID-19 Data Hub](https://covid19datahub.io/), including accuracy, fitness for use, and merchantability. Reliance on the [COVID-19 Data Hub](https://covid19datahub.io/) for medical guidance or use of the [COVID-19 Data Hub](https://covid19datahub.io/) in commerce is strictly prohibited.

## Reference

Guidotti, E., Ardia, D., (2020).      
_COVID-19 Data Hub_       
Working paper   
[https://doi.org/10.13140/RG.2.2.11649.81763](https://doi.org/10.13140/RG.2.2.11649.81763)  

_Note_: We are currently working on improving the way we reference the various data sources for their proper citation.
