% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/COMBIA.R
\name{extractKey}
\alias{extractKey}
\title{Extracts the keyvalues (Barcode) from a dataset, every plate needs barcode.
Keyvalues are extracted from the header of the plates at the position specified by keyposition argument.}
\usage{
extractKey(keyposition, rawdata, numberofrowsperplate, doubleplateexperiment)
}
\arguments{
\item{keyposition}{Position of keyvalue in the header of plate.}

\item{rawdata}{An object(dataframe) of rawdata.}

\item{numberofrowsperplate}{This argument is not needed when you call function "readFluostarPlates". The number of rows depend upon the
geometry of the plates. These are 16 in case of 384well paltes.}

\item{doubleplateexperiment}{This parameter can have TRUE & FALSE values only. It is set to TRUE when an experiment is performed
twice and we only want to choose only one of them.}
}
\value{
A complete set of keyvalues.
}
\description{
Extracts the keyvalues (Barcode) from a dataset, every plate needs barcode.
Keyvalues are extracted from the header of the plates at the position specified by keyposition argument.
}
\examples{
f <- system.file("extdata", "optima.log", package="COMBIA")
fileDF <- readFile(filename = f,  separator = "\\t", noofrows_skip=0,
                   platetype="384")  
Generatedbarcode <- extractKey(keyposition = 2, rawdata = fileDF, 
                              numberofrowsperplate = 17, 
                              doubleplateexperiment = TRUE) 
}
\author{
Muhammad Kashif
}
