% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sensitivity.R
\name{plot_sensitivity}
\alias{plot_sensitivity}
\title{Plot sensitivity indices}
\usage{
plot_sensitivity(SAresults, ptype = "bar")
}
\arguments{
\item{SAresults}{A list of sensitivity/uncertainty analysis results from \code{\link[=plot_sensitivity]{plot_sensitivity()}}.}

\item{ptype}{Type of plot to generate - either \code{"bar"}, \code{"pie"} or \code{"box"}.}
}
\value{
A plot of sensitivity indices generated by ggplot2.
}
\description{
Plots sensitivity indices as bar or pie charts.
}
\details{
To use this function you first need to run \code{\link[=get_sensitivity]{get_sensitivity()}}. Then enter the resulting list as the
\code{SAresults} argument here.

See \code{vignette("sensitivity")}.

This function replaces the now-defunct \code{plotSA()} from COINr < v1.0.
}
\examples{
# for examples, see `vignette("sensitivity")`
# (this is because package examples are run automatically and sensitivity analysis
# can take a few minutes to run at realistic settings)

}
\seealso{
\itemize{
\item \code{\link[=get_sensitivity]{get_sensitivity()}} Perform global sensitivity or uncertainty analysis on a COIN
\item \code{\link[=plot_uncertainty]{plot_uncertainty()}} Plot confidence intervals on ranks following a sensitivity analysis
}
}
