% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convrg_func.R
\name{diff_abund}
\alias{diff_abund}
\title{@encoding UTF-8}
\usage{
diff_abund(model_output, countData)
}
\arguments{
\item{model_output}{Fitted 'Stan' object.}

\item{countData}{Dataframe of count data that was modelled. Should be exactly the same as those data modelled! The first field should be sample name and integer count data should be in all other fields. This is passed in so that the names of fields can be used to make the output of differential relative abundance testing more readable.}
}
\value{
A dataframe with the first field denoting the treatment comparison (e.g., treatment 1 vs. 2) and subsequent fields stating the proportion of samples from the posterior that were greater than zero.
}
\description{
Calculate features with different abundances between treatment groups
}
\details{
This function determines which features within the matrix, be they taxa or molecules, differ in relative abundance among treatment groups.
Pass in a model object, with samples for pi parameters, and the number of treatment groups.
This function only works for pi parameters.

The output of this function gives the proportion of samples that were greater than zero after subtracting two posterior distributions. Therefore, values that are very large or very small denote a high certainty that the distributions subtracted differ.
}
\examples{
com_demo <-matrix(0, nrow = 10, ncol = 10)
com_demo[1:5,] <- c(rep(3,5), rep(7,5)) #Alternates 3 and 7
com_demo[6:10,] <- c(rep(7,5), rep(3,5)) #Reverses alternation
out <- varInf(com_demo,starts = c(1,6), ends=c(5,10))
diff_abund_test <- diff_abund(model_output = out, countData = com_demo)
}
