% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cof_lv_ugb.R
\name{environmental_cof_lv_ugb}
\alias{environmental_cof_lv_ugb}
\title{Environmental cost of Failure for LV UGB}
\source{
DNO Common Network Asset Indices Methodology (CNAIM),
Health & Criticality - Version 2.1, 2021:
\url{https://www.ofgem.gov.uk/sites/default/files/docs/2021/04/dno_common_network_asset_indices_methodology_v2.1_final_01-04-2021.pdf}
}
\usage{
environmental_cof_lv_ugb(lv_asset_category)
}
\arguments{
\item{lv_asset_category}{String The type of LV asset category}
}
\value{
Numeric. Environmental consequences of failure for LV UGB
}
\description{
This function calculates environmental consequences of failure
(cf. section 7.3, page 79, CNAIM, 2021). Environmental consequences
of failure is used in
the derivation of consequences of failure see \code{\link{cof}}().#' @return Numeric. Financial consequences of failure for LV UGB
}
\examples{
environmental_cof_lv_ugb(lv_asset_category = "LV UGB")
}
