% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oil_test_modifier.R
\name{oil_test_modifier}
\alias{oil_test_modifier}
\title{Oil Test Modifier}
\source{
DNO Common Network Asset Indices Methodology (CNAIM),
Health & Criticality - Version 1.1, 2017:
\url{https://www.ofgem.gov.uk/system/files/docs/2017/05/dno_common_network_asset_indices_methodology_v1.1.pdf}
}
\usage{
oil_test_modifier(
  moisture = "Default",
  acidity = "Default",
  bd_strength = "Default"
)
}
\arguments{
\item{moisture}{Numeric. Refers to the moisture level in the
transformer oil. Moisture levels are measured in ppm.
A setting of \code{"Default"} will result in the best possible result.}

\item{acidity}{Numeric. Refers to the acidity level in the
transformer oil. Acidity levels are measured in  (mgKOH/g).
A setting of \code{"Default"} will result in the best possible result.}

\item{bd_strength}{Numeric. Refers to the breakdown strength.
Breakdown strength is measured in kV.
A setting of \code{"Default"} will result in the best possible result.}
}
\value{
Data table.
}
\description{
This function calculates the oil test modifier
for 33/10kV, 66/10kV and 132kV transformers and tapchangers.
See e.g. section 6.11 on page 64 in CNAIM (2017).
}
\examples{
# Oil test modifier
oil_test_modifier(moisture = 15,
acidity = 0.15,
bd_strength = 30)
}
