% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarize_offspring_and_mate_numbers.R
\name{summarize_offspring_and_mate_numbers}
\alias{summarize_offspring_and_mate_numbers}
\title{Summarize the distribution of number of offspring and number of mates}
\usage{
summarize_offspring_and_mate_numbers(
  census_postkill,
  pedigree,
  deaths,
  lifetime_hexbin_width = c(1, 1),
  contrib_bin_width = 0.01
)
}
\arguments{
\item{census_postkill}{a tibble with the postkill numbers of individuals.  This
is here so we know the total number of individuals that could have reproduced in a given
year.}

\item{pedigree}{a tibble with columns of \code{year}, \code{kid}, \code{pa}, and \code{ma}. The IDs of the'
individuals must by like MX_Y where M means male, X is the birth year, and Y is the unique
ID number.}

\item{deaths}{a tibble with columns of \code{ID}, \code{year}, and \code{age}, giving the years and ages at which
different individuals died.}

\item{lifetime_hexbin_width}{a vector of length two.  The first element is the width in the
age direction of each hexbin and the second is the width in the lifetime number of offspring
direction for the \code{plot_lifetime_output_vs_age_at_death} output plot.}

\item{contrib_bin_width}{width of bins of histogram of contribution of parents of
each age and sex to the offspring.}
}
\value{
A list with three components, each of them a ggplot object:
\itemize{
\item \code{plot_age_specific_number_of_offspring}: a ggplot object that plots boxplots and jittered points.
The x-axis are the ages of the individuals; the y-axis shows the number of offspring. Summarized
over the entire spip simulation. This is faceted by sex.
\item \code{plot_lifetime_output_vs_age_at_death}: a ggplot object.  This is a hexbin plot. The x-axis
are age-at-death bins, the y axis are bins of total number of offspring produced in a lifetime.
The fill color of each bin gives the number of individuals with that age at death and number
of offspring encountered over the whole simulation.  Plot is faceted by sex.
\item \code{plot_fraction_of_offspring_from_each_age_class}: a ggplot object. This shows the distribution
over all years of the simulation, of the fraction of offspring produced each year that were
produced by males or females of a given age (the plots are facet-wrapped by both age and sex).
The blue vertical line gives the mean.
}
}
\description{
More later
}
\examples{
# get stored slurped output for an example
X <- species_1_slurped_results
g <- summarize_offspring_and_mate_numbers(
  X$census_postkill,
  X$pedigree,
  X$deaths
)

# Now g is a list holding three plots, accessible like this:

# g$plot_age_specific_number_of_offspring

# g$plot_lifetime_output_vs_age_at_death

# g$plot_fraction_of_offspring_from_each_age_class

}
