% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_conn_comps.R
\name{plot_conn_comps}
\alias{plot_conn_comps}
\title{plot the graph showing the connected components}
\usage{
plot_conn_comps(Pairs)
}
\arguments{
\item{Pairs}{the tibble that comes out of \code{compile_related_pairs()}.
For this function it must have, at least the
columns \code{id_1}, \code{id_2}, and \code{dom_relat}.}
}
\value{
This returns a list with two components:
\itemize{
\item \code{conn_comps}: a tibble with three columns:
\itemize{
\item \code{name}: the name of the sample
\item \code{cluster}: the index of the connected component the sample belongs to
\item \code{cluster_size}: the number of samples belonging
to that cluster
}
\item \code{plot}: a ggraph/ggplot plot object showing the connected components as vertices with
edges between them.
}
}
\description{
This is a simple wrapper for some tidygraph/ggraph functions
that will let you find the connected components of a graph in which
the related pairs are connected by edges.  It also makes
a plot of them.
}
\details{
Note that it appears that the 'ggraph' package must be loaded
for the plot output of this function to print correctly.
}
\examples{
# get a Pairs tibble from the stored data
Pairs <- compile_related_pairs(species_1_slurped_results_1gen$samples)
PCC <-  plot_conn_comps(Pairs)

# look at the conn_comps:
head(PCC$conn_comps)

# if you want to print the plot, that seems to require
# loading the ggraph library
library(ggraph)
PCC$plot
}
