% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ce_estimate_rams_ate.R
\name{ce_estimate_rams_ate}
\alias{ce_estimate_rams_ate}
\title{Regression adjustment with multivariate spline of GPS (RAMS) for ATE estimation}
\usage{
ce_estimate_rams_ate(y, w, x, method, ...)
}
\arguments{
\item{y}{numeric vector for the binary outcome}

\item{w}{numeric vector for the treatment indicator}

\item{x}{dataframe including the treatment indicator and the covariates}

\item{method}{a character string. Users can selected from the following methods including "RAMS-Multinomial", "RAMS-GBM", "RAMS-SL"}

\item{...}{Other paramters to be passed to twang::mnps()}
}
\value{
a list with w*(w-1)/2 elements for ATE effect. Each element of the list contains the estimation, standard error, lower and upper 95\% CI for RD/RR/OR
}
\description{
This function implements the RAMS method when estimand is ATE. Please use our main function ce_estimate.R.
}
\examples{
lp_w_all <-
 c(".4*x1 + .1*x2  - .1*x4 + .1*x5",    # w = 1
   ".2 * x1 + .2 * x2  - .2 * x4 - .3 * x5")  # w = 2
nlp_w_all <-
 c("-.5*x1*x4  - .1*x2*x5", # w = 1
   "-.3*x1*x4 + .2*x2*x5")# w = 2
lp_y_all <- rep(".2*x1 + .3*x2 - .1*x3 - .1*x4 - .2*x5", 3)
nlp_y_all <- rep(".7*x1*x1  - .1*x2*x3", 3)
X_all <- c(
 "rnorm(300, 0, 0.5)",# x1
 "rbeta(300, 2, .4)",   # x2
 "runif(300, 0, 0.5)",# x3
 "rweibull(300,1,2)",  # x4
 "rbinom(300, 1, .4)"# x5
)
set.seed(111111)
data <- data_sim(
 sample_size = 300,
 n_trt = 3,
 X = X_all,
 lp_y = lp_y_all,
 nlp_y  = nlp_y_all,
 align = FALSE,
 lp_w = lp_w_all,
 nlp_w = nlp_w_all,
 tau = c(-1.5,0,1.5),
 delta = c(0.5,0.5),
 psi = 1
)
ce_estimate_rams_ate(y = data$y, x = data$covariates ,
w = data$w, method = "RAMS-Multinomial")
}
