% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CFOeff.next.R
\name{CFOeff.next}
\alias{CFOeff.next}
\title{Determination of the dose level for next cohort in the calibration-free odds (CFO) design for phase I/II trials}
\usage{
CFOeff.next(target, txs, tys, tns, currdose, 
                   prior.para=list(alp.prior = target, bet.prior = 1 - target, 
                   alp.prior.eff = 0.5, bet.prior.eff = 0.5),  
                   cutoff.eli=0.95, early.stop=0.95, effearly.stop = 0.9, mineff)
}
\arguments{
\item{target}{the target DLT rate.}

\item{txs}{the cumulative counts of efficacy outcomes at all dose levels.}

\item{tys}{the cumulative counts of DLTs observed at all dose levels.}

\item{tns}{the cumulative counts of patients treated at all dose levels.}

\item{currdose}{the current dose level.}

\item{prior.para}{the prior parameters for two beta distributions, where set as \code{list(alp.prior = target, 
                 bet.prior = 1 - target, alp.prior.eff = 0.5, bet.prior.eff = 0.5)} by default. \code{alp.prior} and \code{bet.prior}
represent the parameters of the prior distribution for the true DLT rate at any dose level. This prior distribution
is specified as Beta(\code{alpha.prior}, \code{beta.prior}). \code{alp.eff.prior} and \code{bet.eff.prior}
represent the parameters of the Jeffreys' prior distribution for the efficacy probability at any dose level.
This prior distribution is specified as Beta(\code{alpha.eff.prior}, \code{beta.eff.prior}).}

\item{cutoff.eli}{the cutoff to eliminate overly toxic doses for safety. We recommend
the default value of \code{cutoff.eli = 0.95} for general use.}

\item{early.stop}{the threshold value for early stopping due to overly toxic. The default value \code{early.stop = 0.95}
generally works well.}

\item{effearly.stop}{the threshold value for early stopping due to low efficacy. The trial would be terminated
early if \eqn{Pr(q_k<\psi |y_k,m_k \ge 3)} is smaller than the value of \code{effearly.stop} where \eqn{q_k, y_k} and \eqn{m_k}
are the efficacy probability, the number of efficacy outcomes and the number of patients at dose level \eqn{k}.
\eqn{\psi} is the the lowest acceptable efficacy rate which is set by \code{mineff} here.
By default, \code{effearly.stop} is set as \code{0.9}.}

\item{mineff}{the lowest acceptable efficacy rate.}
}
\value{
The \code{CFOeff.next()} function returns a list object comprising the following elements:
\itemize{
\item target: the target DLT rate.
\item txs: the cumulative counts of efficacy outcomes at all dose levels.
\item tys: the cumulative counts of DLTs observed at all dose levels.
\item tns: the cumulative counts of patients treated at all dose levels.
\item decision: the decision in the CFO design, where \code{de-escalation}, \code{stay}, and \code{escalation} represent the
movement directions of the dose level, \code{stop_for_tox} indicates stopping the experiment because the lowest dose level
is overly toxic and \code{stop_for_low_eff} indicates that all dose level in the admissible set shows low efficacy.
\item currdose: the current dose level.
\item nextdose: the recommended dose level for the next cohort. \code{nextdose = 99} indicates that the trial is
terminated due to early stopping.
\item overtox: the situation regarding which positions experience over-toxicity. The dose level indicated
by \code{overtox} and all the dose levels above experience over-toxicity. \code{overtox = NA} signifies that
the occurrence of over-toxicity did not happen.
\item toxprob: the expected toxicity probability, \eqn{Pr(p_k > \phi | x_k, m_k)}, for doses in admissible set,
where \eqn{p_k}, \eqn{x_k}, and \eqn{m_k} are the dose-limiting toxicity (DLT) rate, the
numbers of observed DLTs, and the numbers of patients at dose level \eqn{k}.
\item effprob: the empirical probability of \eqn{Pr(q_k=max_{j\in A_n}\{q_j\}|D_n)} for doses in admissible set,
where \eqn{q_k} is efficacy probability at dose level \eqn{k}. \eqn{A_n} is the admissible set determined through
the dose escalation rules for the MTD and \eqn{D_n} is the current cumulative dataset.
\item admset: the admissible set \eqn{A_n}. The dose level for the next cohort will be selected from \eqn{A_n}.
\item class: the phase of the trial.
}
}
\description{
In the CFO design for phase I/II trials, the function is used to determine the dose movement
based on the toxicity outcomes and efficacy outcomes of the enrolled cohorts.
}
\details{
The CFO design for phase I/II trials will determine admissible set \eqn{A_n} through the dose escalation rules for the MTD. The current dose is set as
\eqn{d_n}. If the decision is to de-escalate the dose, the set \eqn{A_n} will be \eqn{\{1,\dots,d_n-1\}}. If the decision is to stay at the
current dose, then the admissible set \eqn{A_n} will be \eqn{\{1,\dots,d_n\}}. If the decision is to escalate the dose, then \eqn{A_n} will be
\eqn{\{1,\dots,d_n+1\}}. The dose level \eqn{d_{n+1}} for the next cohort will be selected from \eqn{A_n} by using the rule:
\eqn{d_{n+1} = argmax_{k\in A_n}Pr(q_k = max_{j\in A_n}\{q_j\}| D_n)} where \eqn{D_n} and \eqn{q_k} are the current data and the
efficacy probability for dose level \eqn{k}.
}
\examples{
txs = c(3, 1, 7, 11, 26); tys = c(0, 0, 0, 0, 6); tns = c(6, 3, 12, 17, 36)
target <- 0.4
decision <- CFOeff.next(target,txs,tys,tns,currdose = 3, mineff = 0.3)
summary(decision)
\donttest{#early stop for overly toxic
txs = c(13, 11, 7, 11, 26); tys = c(25, 18, 12, 17, 26); tns = c(36, 23, 22, 27, 36)
target <- 0.4
decision <- CFOeff.next(target,txs,tys,tns,currdose = 1, mineff = 0.3)
summary(decision)
}
\donttest{#early stop for low efficacy
txs = c(0, 0, 0, 0, 0); tys = c(2, 1, 1, 1, 6); tns = c(36, 23, 22, 27, 36)
target <- 0.4
decision <- CFOeff.next(target,txs,tys,tns,currdose = 1, mineff = 0.3)
summary(decision)
}
}
\references{
Jin H, Yin G (2022). CFO: Calibration-free odds design for phase I/II clinical trials.
\emph{Statistical Methods in Medical Research}, 31(6), 1051-1066. \cr
}
\author{
Jialu Fang, Wenliang Wang, Ninghao Zhang, and Guosheng Yin
}
