% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cnfa-class.R
\docType{class}
\name{cnfa-class}
\alias{cnfa-class}
\title{cnfa-class}
\description{
An object of class \code{cnfa} is created by performing climate-niche factor
analysis on species presence data using the \code{cnfa} function.
}
\section{Slots}{

\describe{
\item{\code{call}}{Original function call}

\item{\code{mf}}{numeric. Named vector representing the marginality factor, describing
the location of the species niche relative to the global niche}

\item{\code{marginality}}{numeric. Magnitude of the marginality factor \code{mf}, scaled
by the global covariance matrix}

\item{\code{sf}}{numeric. Named vector representing the sensitivity factor}

\item{\code{sensitivity}}{numeric. The magnitude of the sensitivity factor \code{sf},
scaled by the global covariance matrix}

\item{\code{eig}}{numeric. Named vector representing the eigenvalues of specialization,
reflecting the amount of variance on each factor}

\item{\code{co}}{p x p matrix of standardized variable loadings}

\item{\code{cov}}{p x p species covariance matrix}

\item{\code{g.cov}}{p x p global covariance matrix}

\item{\code{ras}}{RasterBrick of transformed climate values, with p layers}

\item{\code{weights}}{Raster layer of weights used for CNFA calculation}
}}

