% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/departure.R
\docType{methods}
\name{departure}
\alias{departure}
\alias{departure,GLdeparture,missing,cnfa-method}
\alias{departure,GLdeparture,missing,Spatial-method}
\alias{departure,Raster,Raster,cnfa-method}
\alias{departure,Raster,Raster,Spatial-method}
\title{Climatic departure}
\usage{
departure(x, y, s.dat, ...)

\S4method{departure}{GLdeparture,missing,cnfa}(x, s.dat, filename = "",
  ...)

\S4method{departure}{GLdeparture,missing,Spatial}(x, s.dat, field,
  fun = "last", filename = "", ...)

\S4method{departure}{Raster,Raster,cnfa}(x, y, s.dat, center = TRUE,
  scale = TRUE, filename = "", progress = FALSE, parallel = FALSE,
  n = 1, ...)

\S4method{departure}{Raster,Raster,Spatial}(x, y, s.dat, center = TRUE,
  scale = TRUE, filename = "", progress = FALSE, parallel = FALSE,
  n = 1, ...)
}
\arguments{
\item{x}{Raster* object, typically a brick or stack of historical climate
raster layers or a brick of absolute differences (see Details)}

\item{y}{Raster* object, future climate values with the same layers as \code{x}}

\item{s.dat}{SpatialPolygons*, sf, or cnfa object detailing species presence}

\item{...}{Additional arguments for \code{\link[raster]{clusterR}}}

\item{filename}{character. Optional filename to save the Raster* output to
file. If this is not provided, a temporary file will be created for large \code{x}}

\item{field}{field of \code{s.dat} that specifies presence. This is
equivalent to the \code{field} argument of \code{raster::rasterize}. Options
are 'first', 'last' (default), and 'count'}

\item{fun}{function or character. Determines what values to assign to cells
with multiple spatial features, similar to the \code{fun} argument in
\code{\link[raster]{rasterize}}}

\item{center}{logical. If \code{TRUE} then the values of \code{x} and
\code{y} will be centered on the means of the historical
climate data}

\item{scale}{logical. If \code{TRUE} then the values of \code{x} and
\code{y} will be scaled by the sds of the historical
climate data}

\item{progress}{logical. If \code{TRUE}, messages and progress bar will be
printed}

\item{parallel}{logical. If \code{TRUE} then multiple cores are utilized}

\item{n}{numeric. Optional number of CPU cores to utilize for parallel processing}
}
\value{
Returns an S4 object of class \code{departure} with the following slots:
\describe{
  \item{call}{Original function call}
  \item{df}{Departure factor. Vector of length p that describes the amount of
   departure between future and historical conditions for each climate variable}
  \item{departure}{Magnitude of the departure factor}
  \item{g.cov}{p x p historical global covariance matrix}
  \item{ras}{RasterBrick of climate departures, with p layers}
  \item{weights}{Raster layer of weights used for departure calculation}
}
}
\description{
This function quantifies the amount of change between historical and future
climate conditions inside a species' habitat.
}
\details{
For comparisons of multiple species in the same study area, it is much more
 efficient to first construct a Raster* object of absolute differences between
 the historical and future values, so that the differences do not need to be
 recalculated for each species. This can be achieved with by passing \code{x}
 and \code{y} to the \code{difRaster} function, and then passing the
 results to the \code{departure} function.

 When only one Raster* object is supplied, it is assumed that \code{x} is
 a Raster* object containing the absolute differences of a historical and
 future dataset.
}
\examples{
dep1 <- departure(x = climdat.hist, y = climdat.fut, s.dat = ABPR, field = "CODE")

# using difRaster as an initial step
# for multi-species comparison

gld <- GLdeparture(x = climdat.hist, y = climdat.fut)
dep2 <- departure(x = gld, s.dat = ABPR, field = "CODE")

# same results either way
all.equal(dep1@df, dep2@df)

}
