% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modelKriging.R
\name{modelKrigingInit}
\alias{modelKrigingInit}
\title{Kriging: Initial guess and bounds}
\usage{
modelKrigingInit(
  startTheta = NULL,
  lowerTheta = NULL,
  upperTheta = NULL,
  useLambda,
  lambdaLower,
  lambdaUpper,
  combineDistances,
  nd,
  distanceParameters = F,
  distanceParametersLower = NA,
  distanceParametersUpper = NA
)
}
\arguments{
\item{startTheta}{user provided start guess (optional).}

\item{lowerTheta}{lower boundary for theta values (log scale), the kernel parameters.}

\item{upperTheta}{upper boundary for theta values (log scale), the kernel parameters.}

\item{useLambda}{boolean, whether nugget effect (lambda) is used.}

\item{lambdaLower}{lower boundary for lambda (log scale).}

\item{lambdaUpper}{upper boundary for lambda (log scale).}

\item{combineDistances}{boolean, whether multiple distances are combined.}

\item{nd}{number of distance function.}

\item{distanceParameters}{whether the distance function parameters should be optimized}

\item{distanceParametersLower}{lower boundary for parameters of the distance function, default is \code{NA} which means there are no distance function parameters. If several distance functions are supplied, this should be a list of lower boundary vectors for each function.}

\item{distanceParametersUpper}{upper boundary for parameters of the distance function, default is \code{NA} which means there are no distance function parameters. If several distance functions are supplied, this should be a list of upper boundary vectors for each function.}
}
\value{
a list with elements \code{x0} (start guess), \code{lower} (lower bound), \code{upper} (upper bound).
}
\description{
Initialize parameter tuning for the Kriging model, setting the initial guess
as well as bound constraints.
}
\seealso{
\code{\link{modelKriging}}
}
\keyword{internal}
