% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_io.R
\name{get_data}
\alias{get_data}
\title{Get one Sentence for Review}
\usage{
get_data(
  uri_fun,
  user,
  password,
  host,
  port,
  database,
  end_user,
  end_user_password,
  html = TRUE,
  position,
  patient_id = NA,
  ldap = FALSE
)
}
\arguments{
\item{uri_fun}{Uniform resource identifier (URI) string generating function for MongoDB credentials.}

\item{user}{MongoDB user name.}

\item{password}{MongoDB user password.}

\item{host}{MongoDB server host.}

\item{port}{MongoDB port.}

\item{database}{MongoDB database name.}

\item{end_user}{CEDARS end user name.}

\item{end_user_password}{CEDARS end user password.}

\item{html}{Should output keywords/concepts be highlighted with HTML markup? Default is TRUE.}

\item{position}{Sentence position within the sequence of selected sentences for a given patient.}

\item{patient_id}{Used if a specific patient record is requested, instead of a search for next record to annotate.}

\item{ldap}{Is LDAP authentication being used? If so, password will not be checked and access will be granted automatically.}
}
\value{
A list with patient-specific information and a dataframe with selected sentences along with sentence-specific data.
}
\description{
Gets one sentence, one note and date of note for one patient. Main way for an end user to query CEDARS.
}
\keyword{internal}
