% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generateConceptCohortSet.R
\name{generateConceptCohortSet}
\alias{generateConceptCohortSet}
\alias{generate_concept_cohort_set}
\title{Create a new generated cohort set from a list of concept sets}
\usage{
generateConceptCohortSet(
  cdm,
  conceptSet = NULL,
  name,
  limit = "first",
  requiredObservation = c(0, 0),
  end = "observation_period_end_date",
  subsetCohort = NULL,
  subsetCohortId = NULL,
  overwrite = TRUE
)

generate_concept_cohort_set(
  cdm,
  concept_set = NULL,
  name = "cohort",
  limit = "first",
  required_observation = c(0, 0),
  end = "observation_period_end_date",
  subset_cohort = NULL,
  subset_cohort_id = NULL,
  overwrite = TRUE
)
}
\arguments{
\item{cdm}{A cdm reference object created by \code{CDMConnector::cdmFromCon} or \code{CDMConnector::cdm_from_con}}

\item{conceptSet, concept_set}{A named list of numeric vectors or Capr concept sets}

\item{name}{The name of the new generated cohort table as a character string}

\item{limit}{Include "first" (default) or "all" occurrences of events in the cohort
\itemize{
\item{"first" will include only the first occurrence of any event in the concept set in the cohort.}
\item{"all" will include all occurrences of the events defined by the concept set in the cohort.}
}}

\item{requiredObservation, required_observation}{A numeric vector of length 2 that specifies the number of days of
required observation time prior to index and post index for an event to be included in the cohort.}

\item{end}{How should the \code{cohort_end_date} be defined?
\itemize{
\item{"observation_period_end_date" (default): The earliest observation_period_end_date after the event start date}
\item{numeric scalar: A fixed number of days from the event start date}
\item{"event_end_date"}: The event end date. If the event end date is not populated then the event start date will be used
}}

\item{subsetCohort, subset_cohort}{A cohort table containing the individuals for which to
generate cohorts for. Only individuals in the cohort table will appear in
the created generated cohort set.}

\item{subsetCohortId, subset_cohort_id}{A set of cohort IDs from the cohort table for which
to include. If none are provided, all cohorts in the cohort table will
be included.}

\item{overwrite}{Should the cohort table be overwritten if it already exists? TRUE (default) or FALSE.}
}
\value{
A cdm reference object with the new generated cohort set table added
}
\description{
Generate a new cohort set from one or more concept sets. Each
concept set will result in one cohort and represent the time during which
the concept was observed for each subject/person. Concept sets can be
passed to this function as:
\itemize{
\item{A named list of numeric vectors, one vector per concept set}
\item{A named list of Capr concept sets}
}

Clinical observation records will be looked up in the respective domain tables
using the vocabulary in the CDM. If a required domain table does not exist in
the cdm object a warning will be given.
Concepts that are not in the vocabulary or in the data will be silently ignored.
If end dates are missing or do not exist, as in the case of the procedure and
observation domains, the the start date will be used as the end date.
}
