% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{run_sgrna_quant}
\alias{run_sgrna_quant}
\title{A function to run a sgRNA quantification algorithm from NGS sample}
\usage{
run_sgrna_quant(lib_path, design, map_path = NULL, sampling_ratio = NULL)
}
\arguments{
\item{lib_path}{The path of the FASTA file.}

\item{design}{A table contains the study design. It must contain `fastq_path` and `sample_name.`}

\item{map_path}{The path of file contains gene-sgRNA mapping.}

\item{sampling_ratio}{NULL as a default, and will be treated as a ratio of the subsamping for each NGS file if a numeric value belongs to the parameter.}
}
\value{
It will return a list, and the list contains three elements. 
  The first element (`count') is a data frame contains the result of the quantification for each sample. 
  The second element (`total') is a numeric vector contains the total number of reads of each sample.
  The last element (`sequence') a data frame contains the sequence of each sgRNA in the library.
}
\description{
A function to run a sgRNA quantification algorithm from NGS sample
}
\examples{
library(CB2)
library(magrittr)
library(tibble)
library(dplyr)
library(glue)
FASTA <- system.file("extdata", "toydata", "small_sample.fasta", package = "CB2")
ex_path <- system.file("extdata", "toydata", package = "CB2")

df_design <- tribble(
  ~group, ~sample_name,
  "Base", "Base1",  
  "Base", "Base2", 
  "High", "High1",
  "High", "High2") \%>\% 
    mutate(fastq_path = glue("{ex_path}/{sample_name}.fastq"))

cb2_count <- run_sgrna_quant(FASTA, df_design)

}
