/*
 * Decompiled with CFR 0.152.
 */
package org.neptuneinc.cadstat.plots;

import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jdesktop.layout.GroupLayout;
import org.neptuneinc.cadstat.utils.RUtils;
import org.rosuda.JGR.JGR;

public class BiologicalInferences
extends JDialog
implements ListSelectionListener,
DocumentListener {
    private JTextField bcnt;
    private JButton bcntBrowse;
    private JLabel bcntLabel;
    private JButton cancelButton;
    private JTextField coeffs;
    private JButton coeffsBrowse;
    private JLabel coeffsLabel;
    private JTextField dataDir;
    private JButton dataDirBrowse;
    private JLabel dataDirLabel;
    private JButton helpButton;
    private JRadioButton importOpTax;
    private JRadioButton importTaxMerge;
    private JTextField maxLike;
    private JButton maxLikeBrowse;
    private JLabel maxLikeLabel;
    private JTextField opTax;
    private JButton opTaxBrowse;
    private JLabel opTaxLabel;
    private ButtonGroup optionsGroup;
    private JRadioButton runAll;
    private JSeparator separator1;
    private JSeparator separator2;
    private JButton submitButton;
    private JTextField taxMerge;
    private JButton taxMergeBrowse;
    private JLabel taxMergeLabel;

    public BiologicalInferences() {
        JTextField[] textFields;
        this.initComponents();
        for (JTextField textField : textFields = new JTextField[]{this.dataDir, this.coeffs, this.bcnt, this.taxMerge, this.opTax, this.maxLike}) {
            textField.getDocument().addDocumentListener(this);
        }
        this.updateValidity();
    }

    private void initComponents() {
        this.optionsGroup = new ButtonGroup();
        this.dataDirLabel = new JLabel();
        this.dataDir = new JTextField();
        this.dataDirBrowse = new JButton();
        this.runAll = new JRadioButton();
        this.importTaxMerge = new JRadioButton();
        this.importOpTax = new JRadioButton();
        this.separator1 = new JSeparator();
        this.coeffsLabel = new JLabel();
        this.coeffs = new JTextField();
        this.coeffsBrowse = new JButton();
        this.bcntLabel = new JLabel();
        this.bcnt = new JTextField();
        this.bcntBrowse = new JButton();
        this.taxMergeLabel = new JLabel();
        this.taxMerge = new JTextField();
        this.taxMergeBrowse = new JButton();
        this.opTaxLabel = new JLabel();
        this.opTax = new JTextField();
        this.opTaxBrowse = new JButton();
        this.maxLikeLabel = new JLabel();
        this.maxLike = new JTextField();
        this.maxLikeBrowse = new JButton();
        this.separator2 = new JSeparator();
        this.cancelButton = new JButton();
        this.submitButton = new JButton();
        this.helpButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Biological Inferences");
        this.dataDirLabel.setText("Data Directory:");
        this.dataDir.setEditable(false);
        String workingDir = RUtils.evalAsString("getwd()");
        workingDir = workingDir != null ? workingDir.replace('\\', '/') : System.getProperty("user.home");
        this.dataDir.setText(workingDir);
        this.dataDirBrowse.setText("Browse...");
        this.dataDirBrowse.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                BiologicalInferences.this.dataDirBrowseActionPerformed(evt);
            }
        });
        this.optionsGroup.add(this.runAll);
        this.runAll.setSelected(true);
        this.runAll.setText("Run Entire Process");
        this.runAll.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.runAll.setMargin(new Insets(0, 0, 0, 0));
        this.runAll.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                BiologicalInferences.this.runAllActionPerformed(evt);
            }
        });
        this.optionsGroup.add(this.importTaxMerge);
        this.importTaxMerge.setText("Start with Taxonomic Merge File");
        this.importTaxMerge.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.importTaxMerge.setMargin(new Insets(0, 0, 0, 0));
        this.importTaxMerge.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                BiologicalInferences.this.importTaxMergeActionPerformed(evt);
            }
        });
        this.optionsGroup.add(this.importOpTax);
        this.importOpTax.setText("Start with Operational Taxonomy File");
        this.importOpTax.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.importOpTax.setMargin(new Insets(0, 0, 0, 0));
        this.importOpTax.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                BiologicalInferences.this.importOpTaxActionPerformed(evt);
            }
        });
        this.coeffsLabel.setText("Coefficients File:");
        this.coeffs.setText("coefs.rda");
        this.coeffsBrowse.setText("Browse...");
        this.coeffsBrowse.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                BiologicalInferences.this.coeffsBrowseActionPerformed(evt);
            }
        });
        this.bcntLabel.setText("Benthic Count File:");
        this.bcnt.setText("benthicCount.txt");
        this.bcntBrowse.setText("Browse...");
        this.bcntBrowse.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                BiologicalInferences.this.bcntBrowseActionPerformed(evt);
            }
        });
        this.taxMergeLabel.setText("Taxonomic Merge File:");
        this.taxMerge.setText("taxMerge.txt");
        this.taxMergeBrowse.setText("Browse...");
        this.taxMergeBrowse.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                BiologicalInferences.this.taxMergeBrowseActionPerformed(evt);
            }
        });
        this.opTaxLabel.setText("Operational Taxonomy File:");
        this.opTax.setText("OTU.txt");
        this.opTaxBrowse.setText("Browse...");
        this.opTaxBrowse.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                BiologicalInferences.this.opTaxBrowseActionPerformed(evt);
            }
        });
        this.maxLikeLabel.setText("Maximum Likelihood File:");
        this.maxLike.setColumns(12);
        this.maxLike.setText("MaxLikEnv.txt");
        this.maxLikeBrowse.setText("Browse...");
        this.maxLikeBrowse.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                BiologicalInferences.this.maxLikeBrowseActionPerformed(evt);
            }
        });
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                BiologicalInferences.this.cancelButtonActionPerformed(evt);
            }
        });
        this.submitButton.setText("Submit");
        this.submitButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                BiologicalInferences.this.submitButtonActionPerformed(evt);
            }
        });
        this.helpButton.setText("Help");
        this.helpButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                BiologicalInferences.this.helpButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add(12, 12, 12).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add(12, 12, 12).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.runAll).add((Component)this.importTaxMerge).add((Component)this.importOpTax))).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.dataDirLabel).addPreferredGap(0).add((Component)this.dataDir, -1, 356, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.dataDirBrowse)))).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.maxLikeLabel).addPreferredGap(0).add((Component)this.maxLike, -1, 289, Short.MAX_VALUE)).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.opTaxLabel).addPreferredGap(0).add((Component)this.opTax, -1, 278, Short.MAX_VALUE)).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.taxMergeLabel).addPreferredGap(0).add((Component)this.taxMerge, -1, 310, Short.MAX_VALUE)).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.bcntLabel).addPreferredGap(0).add((Component)this.bcnt, -1, 332, Short.MAX_VALUE)).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.coeffsLabel).addPreferredGap(0).add((Component)this.coeffs, -1, 345, Short.MAX_VALUE))).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(2, false).add((Component)this.opTaxBrowse, -1, -1, Short.MAX_VALUE).add((Component)this.maxLikeBrowse, -1, -1, Short.MAX_VALUE).add((Component)this.bcntBrowse, -1, -1, Short.MAX_VALUE).add((Component)this.coeffsBrowse, -1, -1, Short.MAX_VALUE).add((Component)this.taxMergeBrowse)))).addContainerGap()).add((Component)this.separator1, -1, 580, Short.MAX_VALUE).add((Component)this.separator2, -1, 580, Short.MAX_VALUE).add((GroupLayout.Group)layout.createSequentialGroup().add(171, 171, 171).add((Component)this.cancelButton).addPreferredGap(0).add((Component)this.submitButton).addPreferredGap(0).add((Component)this.helpButton).addContainerGap(182, Short.MAX_VALUE)));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.dataDirLabel).add((Component)this.dataDirBrowse).add((Component)this.dataDir, -2, -1, -2)).addPreferredGap(0).add((Component)this.runAll).addPreferredGap(0).add((Component)this.importTaxMerge).addPreferredGap(0).add((Component)this.importOpTax).addPreferredGap(1).add((Component)this.separator1, -2, 8, -2).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.coeffsLabel).add((Component)this.coeffsBrowse).add((Component)this.coeffs, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.bcntLabel).add((Component)this.bcnt, -2, -1, -2).add((Component)this.bcntBrowse)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.taxMergeLabel).add((Component)this.taxMerge, -2, -1, -2).add((Component)this.taxMergeBrowse)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.opTaxLabel).add((Component)this.opTax, -2, -1, -2).add((Component)this.opTaxBrowse)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.maxLikeLabel).add((Component)this.maxLike, -2, 19, -2).add((Component)this.maxLikeBrowse, -2, 25, -2)).addPreferredGap(1).add((Component)this.separator2, -2, 10, -2).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.submitButton).add((Component)this.cancelButton).add((Component)this.helpButton)).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private void taxMergeBrowseActionPerformed(ActionEvent evt) {
        this.setTextUsingFileChooser(this.taxMerge, 0);
    }

    private void maxLikeBrowseActionPerformed(ActionEvent evt) {
        this.setTextUsingFileChooser(this.maxLike, 0);
    }

    private void opTaxBrowseActionPerformed(ActionEvent evt) {
        this.setTextUsingFileChooser(this.opTax, 0);
    }

    private void coeffsBrowseActionPerformed(ActionEvent evt) {
        this.setTextUsingFileChooserStartInWorkspace(this.coeffs, 0);
    }

    private void bcntBrowseActionPerformed(ActionEvent evt) {
        this.setTextUsingFileChooser(this.bcnt, 0);
    }

    private void dataDirBrowseActionPerformed(ActionEvent evt) {
        int fcReturnState = this.setTextUsingFileChooser(this.dataDir, 1);
        if (fcReturnState == 0) {
            String dir = this.dataDir.getText();
            this.updateValidity();
        }
    }

    private void importOpTaxActionPerformed(ActionEvent evt) {
        this.updateValidity();
    }

    private void importTaxMergeActionPerformed(ActionEvent evt) {
        this.updateValidity();
    }

    private void runAllActionPerformed(ActionEvent evt) {
        this.updateValidity();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void submitButtonActionPerformed(ActionEvent evt) {
        String maxLikePath = this.maxLike.getText().replace('\\', '/');
        maxLikePath = (maxLikePath.contains("/") ? "" : this.dataDir.getText() + "/") + maxLikePath;
        String cmd = "bioinfer1.JGR( bencntFile='" + this.bcnt.getText().replace('\\', '/') + "'" + ", coefficientFile=" + "'" + this.coeffs.getText().replace('\\', '/') + "'" + ", runTaxonomic=" + String.valueOf(this.runAll.isSelected()).toUpperCase() + ", taxonomicFile=" + "'" + this.taxMerge.getText().replace('\\', '/') + "'" + ", runOTU=" + String.valueOf(this.runAll.isSelected() || this.importTaxMerge.isSelected()).toUpperCase() + ", otuFile=" + "'" + this.opTax.getText().replace('\\', '/') + "'" + ", mlFile=" + "'" + maxLikePath + "' )";
        JGR.MAINRCONSOLE.execute(cmd, true);
        this.dispose();
    }

    private void helpButtonActionPerformed(ActionEvent evt) {
        String cmd = "CADStat.help('bioinfer.JGR')";
        JGR.MAINRCONSOLE.execute(cmd, true);
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.updateValidity();
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.updateValidity();
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.updateValidity();
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.updateValidity();
    }

    protected void updateValidity() {
        boolean isGlobalInputValid = this.isInputFileValid(this.coeffs.getText());
        boolean isGlobalOutputValid = this.isOutputFileValid(this.maxLike.getText());
        boolean isRunAllValid = this.runAll.isSelected() && isGlobalInputValid && this.isInputFileValid(this.bcnt.getText()) && isGlobalOutputValid;
        boolean isImportTaxMergeValid = this.importTaxMerge.isSelected() && isGlobalInputValid && this.isInputFileValid(this.taxMerge.getText()) && isGlobalOutputValid;
        boolean isImportOpTaxValid = this.importOpTax.isSelected() && isGlobalInputValid && this.isInputFileValid(this.opTax.getText()) && isGlobalOutputValid;
        boolean enableSubmitButton = isRunAllValid || isImportTaxMergeValid || isImportOpTaxValid;
        this.bcntLabel.setEnabled(this.runAll.isSelected());
        this.bcnt.setEnabled(this.runAll.isSelected());
        this.bcntBrowse.setEnabled(this.runAll.isSelected());
        this.taxMergeLabel.setEnabled(!this.importOpTax.isSelected());
        this.taxMerge.setEnabled(!this.importOpTax.isSelected());
        this.taxMergeBrowse.setEnabled(this.importTaxMerge.isSelected());
        this.opTaxBrowse.setEnabled(this.importOpTax.isSelected());
        this.submitButton.setEnabled(enableSubmitButton);
    }

    private int setTextUsingFileChooser(JTextField textField, int mode) {
        JFileChooser fc = new JFileChooser(this.dataDir.getText());
        fc.setMultiSelectionEnabled(false);
        fc.setFileSelectionMode(mode);
        int fcReturnState = fc.showOpenDialog(this);
        if (fcReturnState == 0) {
            textField.setText(fc.getSelectedFile().toString().replace('\\', '/'));
        }
        return fcReturnState;
    }

    private int setTextUsingFileChooserStartInWorkspace(JTextField textField, int mode) {
        JFileChooser fc = new JFileChooser(RUtils.evalAsString("file.path(R.home(),'library','CADStat','workspace','data')"));
        fc.setMultiSelectionEnabled(false);
        fc.setFileSelectionMode(mode);
        int fcReturnState = fc.showOpenDialog(this);
        if (fcReturnState == 0) {
            textField.setText(fc.getSelectedFile().toString().replace('\\', '/'));
        }
        return fcReturnState;
    }

    private boolean isInputFileValid(String file) {
        File dataDirFile = new File(this.dataDir.getText());
        boolean isFileExists = new File(file).exists();
        boolean isFileExistsInDataDir = new File(dataDirFile, file).exists();
        return isFileExists || isFileExistsInDataDir;
    }

    private boolean isOutputFileValid(String file) {
        return file != null && file.trim().length() > 0;
    }
}

