% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/growforest.R
\name{growforest}
\alias{growforest}
\title{Grow a forest of classification trees or tree-based treatment regimes}
\usage{
growforest(data, X, Y, ntrees, regmod = NULL, A = NULL, regime = FALSE,
  minsplit = 40, minbucket = 20, maxdepth = 3)
}
\arguments{
\item{data}{The data set from which bootstrap samples should be drawn, or the data sets on which the trees should be grown}

\item{X}{The names of the predictor variables in the data set that will be used as possible split variables}

\item{Y}{The name of the outcome variable(s) in the data set}

\item{ntrees}{The number of trees that should be grown on each data set (i.e., the number of bootstrap samples that should be drawn)}

\item{regmod}{NULL by default, in case of a treatment regime, it should contain the outcome model that should be used for the augmentation}

\item{A}{NULL by default, in case of a treatment regime, it should denote the name of the variable that indicates the assigned treatment alternative in the data set}

\item{regime}{FALSE by default, TRUE if tree-based treatment regimes instead of classification trees are desired.}

\item{minsplit}{40 by default, indicates the he minimum number of observations that must exist in a node in order for a split to be attempted.}

\item{minbucket}{20 by default, indicates the minimum number of observations in any terminal node.}

\item{maxdepth}{3 by default, the maximum depth of any node of the final tree, with the root node counted as depth 0.}
}
\value{
\item{partytrees}{The classification trees or tree-based treatment regimes saved as party objects}
\item{Boots}{The drawn bootstrap samples on which the trees/treatment regimes were based}
}
\description{
Function to grow a forest based on (a) one data set and one outcome variable, by drawing bootstrap samples and growing a tree on each bootstrap sample, (b) one data set and multiple outcome variables, by drawing bootstrap samples and growing a tree for each outcome variable on each bootstrap sample, (c) multiple data sets and one outcome variable, by growing a tree on each data set. Trees can be either classification trees estimated using rpart or tree-based treatment regimes estimated using the method of Zhang et al (2012) with the AIPWE and rpart
}
\examples{
require(MASS)

# Create forest by drawing bootstrap samples and growing a tree on each bootstrap sample
forest <- growforest(data = Pima.tr, X = c("npreg", "glu",  "bp",  "skin",  "bmi", "ped", "age"), 
Y = "type", ntrees = 50)

# Create forest by drawing bootstrap samples and growing a tree for each outcome variable
# on each bootstrap sample
forest <- growforest(data= drugs, X =c ("Age", "Gender", "Edu", "Neuro", "Extr", "Open", "Agree", 
"Consc", "Impul","Sensat"), Y = c("Amphet", "Benzos", "Coke", "Ecst", "Leghighs", "LSD", "Mush",
 "Amyl", "Ket"), ntrees = 8)
}
\references{
\cite{Zhang, B., Tsiatis, A. A., Davidian, M., Zhang, M., & Laber, E. (2012). Estimating optimal treatment regimes from a classification perspective. Stat, 1(1), 103-114.}
}
