% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.S3sensitivity.R
\name{plot.S3sensitivity}
\alias{plot.S3sensitivity}
\alias{autoplot.S3sensitivity}
\title{Graphical Display for Sensitivity Analysis}
\usage{
\method{plot}{S3sensitivity}(x, plot = TRUE, ...)

\method{autoplot}{S3sensitivity}(
  object,
  col = NULL,
  ci = TRUE,
  band = TRUE,
  label = "Threshold for",
  position = NULL,
  size.line = 1,
  size.point = 1.75,
  size.ci = 0.5,
  alpha = 0.1,
  ...
)
}
\arguments{
\item{plot}{[logical] should the graph be displayed in a graphical window}

\item{...}{not used. For compatibility with the generic method.}

\item{object, x}{output of the sensitivity method}

\item{col}{[character vector] color used to identify the thresholds relative to a second variable.}

\item{ci}{[logical] should the confidence intervals be displayed?}

\item{band}{[logical] should the simulatenous confidence intervals be displayed?}

\item{label}{[character] text used before the name of the variables in the legend.}

\item{position}{relative position of the error bars for a given x value. Can for instance be \code{position_dodge(width = 5)}.}

\item{size.line}{[numeric] width of the line connecting the point estimates.}

\item{size.point}{[numeric] size of the point representing the point estimates.}

\item{size.ci}{[numeric] width of the lines representing the confidence intervals.}

\item{alpha}{[numeric] transparency for the area representing the simultaneous confidence intervals.}
}
\value{
a ggplot2 object
}
\description{
Display the statistic of interest across various threshold values, possibly with confidence intervals.
Currently only works when varying thresholds relative to one or two variables.
}
\details{
The \code{autoplot} and \code{plot} methods are very similar. The main difference is that the former returns a ggplot2 object whereas the later automatically display the figure in a graphical window and returns an (invible) list with the plot and the data.
}
\keyword{hplot}
