% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prodlim-iid.R
\name{iidProdlim}
\alias{iidProdlim}
\title{Extract i.i.d. decomposition from a prodlim model}
\usage{
iidProdlim(object, add0 = FALSE)
}
\arguments{
\item{object}{A prodlim object.}

\item{add0}{[logical] add the 0 to vector of relevant times.}
}
\description{
Compute the influence function for each observation used to estimate the model
}
\details{
This function is a simplified version of the iidCox function of the riskRegression package.
Formula for the influence function can be found in (Ozenne et al., 2017).
}
\examples{
library(data.table)
library(prodlim)

set.seed(10)
dt <- simBuyseTest(10)
setkeyv(dt, "treatment")

e.KM <- prodlim(Hist(eventtime,status)~treatment, data = dt)
iidProdlim(e.KM)
}
\references{
Brice Ozenne, Anne Lyngholm Sorensen, Thomas Scheike, Christian Torp-Pedersen and Thomas Alexander Gerds.
riskRegression: Predicting the Risk of an Event using Cox Regression Models.
The R Journal (2017) 9:2, pages 440-460.
}
\author{
Brice Ozenne
}
