% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/individual.est.R
\name{individual.est}
\alias{individual.est}
\title{Estimate individual-level partial correlation coefficients}
\usage{
individual.est(X, alpha = 0.05, lambda = NULL, ci = TRUE)
}
\arguments{
\item{X}{time series data of an individual which is a \eqn{n*p} numeric matrix.}

\item{alpha}{significance level, default value is \code{0.05}.}

\item{lambda}{a penalty parameter used in lasso of order \code{sqrt(log(p)/n)}, if \code{NULL}, \code{2*sqrt(log(p)/n)} will be used.}

\item{ci}{a logical indicating whether to compute \eqn{1-\alpha} confidence interval, default value is \code{TRUE}.}
}
\value{
An \code{indEst} class object containing two or four components.

\code{coef} a \eqn{p*p} partial correlation coefficients matrix.

\code{ci.lower} a \eqn{p*p} numeric matrix containing the lower bound of \eqn{1-\alpha} confidence interval,
returned if \code{ci} is \code{TRUE}.

\code{ci.upper} a \eqn{p*p} numeric matrix containing the upper bound of \eqn{1-\alpha} confidence interval,
returned if \code{ci} is \code{TRUE}.

\code{asym.ex} a matrix measuring the asymptotical expansion of estimates, which will be used for multiple tests.
}
\description{
Estimate individual-level partial correlation coefficients in time series data
with \eqn{1-\alpha} confidence interval.
It's not a joint confidence interval for multiple tests.
\cr
\cr
}
\examples{
## Quick example for the individual-level estimates
data(indsim)
pc = individual.est(indsim)       # estimating partial correlation coefficients

}
\references{
Qiu Y. and Zhou X. (2021).
Inference on multi-level partial correlations
based on multi-subject time series data,
\emph{Journal of the American Statistical Association}, 00, 1-15
}
