% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_seq_rate.R
\name{estimate_seq_rate}
\alias{estimate_seq_rate}
\title{Estimate the average organic carbon sequestration rate}
\usage{
estimate_seq_rate(
  df = NULL,
  timeframe = 100,
  core = "core",
  mind = "mind_corrected",
  maxd = "maxd_corrected",
  dbd = "dbd",
  oc = "eoc",
  age = "age"
)
}
\arguments{
\item{df}{A data.frame with, at least, columns: core, mind (minimum depth of the sample),
maxd (maximum depth of the sample), dbd (dry bulk density), oc (organic carbon \%),
age (age of the sample obtained from a age-depth or age-accumulated mass model)}

\item{timeframe}{standardization time frame, by default 100 years}

\item{core}{Character Name of the column reporting core ID.}

\item{mind}{Character Name of the column reporting the minimum depth of each sample.}

\item{maxd}{Character Name of the column reporting the maximum depth of each sample.}

\item{dbd}{Character Name of the column reporting dry bulk density.}

\item{oc}{Character Name of the column reporting organic carbon concentrations.}

\item{age}{Character Name of the column reporting the age of each sample.}
}
\value{
data.frame with columns 'core', seq_rate_wc (organic carbon sequestration rates at the whole core),
maxage (maximum age of the core), and seq_rate (average organic carbon sequestration rate at the indicated time frame)
}
\description{
estimate the average organic carbon sequestration rate to the soil in a indicated time frame (by default last 100 years)
from the organic carbon concentration and ages obtained from a age-depth or age-accumulated mass model
}
\examples{
bluecarbon_decompact <- decompact(bluecarbon_data)
oc <- estimate_oc(bluecarbon_decompact)
out <- estimate_seq_rate(oc[[1]])
head(out)
}
