% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jackKnife.R
\name{jackKnife}
\alias{jackKnife}
\title{Jackknifes a dataset.}
\usage{
jackKnife(DF, N, PR = 0.85, DIR = F)
}
\arguments{
\item{DF}{data frame, matrix or any R object wich responds to function rownames().}

\item{N}{number of desired jackknifed datasets.}

\item{PR}{proportion of entries to DF that will be kept in the jackknifed datasets. Default is 0.85.}

\item{DIR}{directory whre to save the jackknifed datasets. If FALSE (default) will not save to disk.}
}
\value{
list of jacknifed datasets. If DIR is specified also a folder in directory DIR containing one .RDS file per jackknifed dataset (with extension .jds - Jackknifed Data Set) will be created.
}
\description{
This function performes jackknife resampling on a dataset.
}
\examples{
data('frogs')
frogsJK<- jackKnife(DF= frogs, N= 10)
}
\author{
Luca Butikofer
}
