% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotusingrgraphviz.R
\name{plot2in1}
\alias{plot2in1}
\title{Highlighting similarities between two graphs}
\usage{
plot2in1(graph1, graph2, bidir = FALSE, ...)
}
\arguments{
\item{graph1}{binary adjacency matrix of a graph}

\item{graph2}{binary adjacency matrix of a graph, column names should coincide with column names of 'graph1'}

\item{bidir}{logical, defines arrows of bidirected edges are drawn; FALSE by defauls.}

\item{...}{optional parameters passed to \pkg{Rgraphviz} plotting functions e.g. \code{main}, \code{fontsize}}
}
\value{
plots the graph which includes nodes and edges two graphs; nodes which are connected to at least one other node in both graphs are plotted only once and coloured orange, edges which are shared by two graphs
are coloured orange; all other nodes and edges a plotted once for each 'graph1' and 'graph2' and coloured blue and green accordingly.
}
\description{
This function plots nodes and edges from two graphs in one and indicates similarities between these graphs.
}
\author{
Polina Suter
}
