% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotusingrgraphviz.R
\name{plotdiffs}
\alias{plotdiffs}
\title{Plotting difference between two graphs}
\usage{
plotdiffs(edag, truedag, clusters = NULL)
}
\arguments{
\item{edag}{object of class graphNEL (or its adjacency matrix), representing estimated structure (not necessarily acyclic) to be compared to the ground truth graph}

\item{truedag}{object of class graphNEL (or its adjacency matrix), representing the ground truth structure (not necessarily acyclic)}

\item{clusters}{(optional) a list of nodes to be represented on the graph as clusters}
}
\value{
plots the graph which includes edges from edag and truedag, however edges which are different in edag compared to truedag are coloured according to the type of a mistake: false positive with red, false negative with dashed grey, error in direction with magenta
}
\description{
This function plots an estimated graph such that the edges which are different to the ground truth graph are highlighted.
}
\examples{
Asiascore<-scoreparameters(8,"bde",Asia)
Asiamap<-orderMCMC(Asiascore)
plotdiffs(Asiamap$max$DAG,Asiamat)
Asiacp<-pcalg::dag2cpdag(m2graph(Asiamat))
mapcp<-pcalg::dag2cpdag(m2graph(Asiamap$max$DAG))
plotdiffs(mapcp,Asiacp)
}
