% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/atlasDownloader.R
\name{atlasDownloader}
\alias{atlasDownloader}
\title{Download occurrence data from the Atlas of Living Australia (ALA)}
\usage{
atlasDownloader(
  path,
  userEmail = NULL,
  ALA_taxon,
  DL_reason = 4,
  atlas = "ALA"
)
}
\arguments{
\item{path}{A character directory. The path to a folder where the download will be stored.}

\item{userEmail}{A character string. The email used associated with the user's ALA account;
user must make an ALA account to download data.}

\item{ALA_taxon}{A character string. The taxon to download from ALA. Uses \code{\link[galah:galah_identify]{galah::galah_identify()}}}

\item{DL_reason}{Numeric. The reason for data download according to \code{\link[galah:galah_config]{galah::galah_config()}}}

\item{atlas}{Character. The atlas to download occurrence data from - see here https://galah.ala.org.au/R/articles/choosing_an_atlas.html for details.
Note: the default is "ALA" and is probably the only atlas which will work seamlessly with the rest
of the workflow. However, different atlases can still be downloaded and a doi will be sent to
your email.}
}
\value{
Completes an ALA data download and saves those data to the path provided.
}
\description{
Downloads ALA data and creates a new file in the path to put those data. This function can also
request downloads from other atlases (see: http://galah.ala.org.au/articles/choosing_an_atlas.html).
However, it will only send the download to your email and you must do the rest yourself at this point.
}
\examples{
\dontrun{
atlasDownloader(path = DataPath,
               userEmail = "InsertYourEmail",
               ALA_taxon = "Apiformes",
               DL_reason = 4)
               }
}
