/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.substmodel;

import dr.evomodel.siteratemodel.SiteRateModel;
import dr.evomodel.substmodel.ColtEigenSystem;
import dr.evomodel.substmodel.EigenDecomposition;
import dr.evomodel.substmodel.EigenSystem;
import dr.evomodel.substmodel.ProductChainSubstitutionModel;
import dr.evomodel.substmodel.SubstitutionModel;
import dr.inference.model.Parameter;
import dr.math.KroneckerOperation;
import java.util.List;

public class DependentProductChainSubstitutionModel
extends ProductChainSubstitutionModel {
    private final Parameter dependenceParameter;
    private final EigenSystem eigenSystemCES;

    public DependentProductChainSubstitutionModel(String string, List<SubstitutionModel> list, Parameter parameter) {
        this(string, list, null, parameter);
    }

    public DependentProductChainSubstitutionModel(String string, List<SubstitutionModel> list, List<SiteRateModel> list2, Parameter parameter) {
        super(string, list, list2);
        this.dependenceParameter = parameter;
        this.eigenSystemCES = new ColtEigenSystem(this.stateCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EigenDecomposition getEigenDecomposition() {
        DependentProductChainSubstitutionModel dependentProductChainSubstitutionModel = this;
        synchronized (dependentProductChainSubstitutionModel) {
            if (this.updateMatrix) {
                this.computeKroneckerSumsAndProducts();
            }
        }
        return this.eigenDecomposition;
    }

    @Override
    public void getInfinitesimalMatrix(double[] dArray) {
        this.getEigenDecomposition();
        System.arraycopy(this.rateMatrix, 0, dArray, 0, this.stateCount * this.stateCount);
    }

    private void computeKroneckerSumsAndProducts() {
        int n;
        int n2;
        int n3;
        Object[] objectArray;
        int n4;
        int n5 = this.stateSizes[0];
        double[] dArray = new double[n5 * n5];
        ((SubstitutionModel)this.baseModels.get(0)).getInfinitesimalMatrix(dArray);
        dArray = this.scaleForProductChain(dArray, 0);
        for (int i = 1; i < this.numBaseModel; ++i) {
            SubstitutionModel substitutionModel = (SubstitutionModel)this.baseModels.get(i);
            n4 = this.stateSizes[i];
            objectArray = new double[n4 * n4];
            substitutionModel.getInfinitesimalMatrix((double[])objectArray);
            objectArray = this.scaleForProductChain((double[])objectArray, i);
            dArray = KroneckerOperation.sum(dArray, n5, objectArray, n4);
            n5 *= n4;
        }
        double d = this.dependenceParameter.getParameterValue(0);
        for (n4 = 0; n4 < this.stateCount; ++n4) {
            dArray[(n4 + 1) * this.stateCount - (n4 + 1)] = d;
        }
        String[] stringArray = new String[(int)Math.sqrt(this.stateCount)];
        objectArray = new String[(int)Math.sqrt(this.stateCount)];
        String[] stringArray2 = new String[this.stateCount];
        int n6 = 0;
        for (n3 = 0; n3 < stringArray.length; ++n3) {
            stringArray[n3] = String.valueOf(n6);
            objectArray[n3] = (double)String.valueOf(n6);
            ++n6;
        }
        n3 = 0;
        for (n2 = 0; n2 < stringArray.length; ++n2) {
            for (n = 0; n < objectArray.length; ++n) {
                stringArray2[n3] = stringArray[n2] + " " + (String)objectArray[n];
                ++n3;
            }
        }
        for (n2 = 0; n2 < stringArray2.length; ++n2) {
            for (n = 0; n < stringArray2.length; ++n) {
                String[] stringArray3;
                String[] stringArray4 = stringArray2[n2].split(" ");
                if (stringArray4[0].equals((stringArray3 = stringArray2[n].split(" "))[0]) || stringArray4[1].equals(stringArray3[1])) continue;
                dArray[n2 * this.stateCount + n] = d;
            }
        }
        double d2 = 0.0;
        for (int i = 0; i < this.stateCount; ++i) {
            for (int j = i * this.stateCount; j < (i + 1) * this.stateCount; ++j) {
                if (j == i * this.stateCount + i) continue;
                d2 += dArray[j];
            }
            dArray[i * this.stateCount + i] = -d2;
            d2 = 0.0;
        }
        this.rateMatrix = dArray;
        this.decompose();
    }

    private void decompose() {
        double[][] dArray = new double[this.stateCount][this.stateCount];
        for (int i = 0; i < this.stateCount; ++i) {
            System.arraycopy(this.rateMatrix, i * this.stateCount, dArray[i], 0, this.stateCount);
        }
        this.eigenDecomposition = this.eigenSystemCES.decomposeMatrix(dArray);
        this.updateMatrix = false;
    }
}

