/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.epidemiology;

import dr.evomodel.epidemiology.DynamicalForce;
import dr.evomodel.epidemiology.DynamicalVariable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class DynamicalSystem {
    private List<DynamicalVariable> variables = new ArrayList<DynamicalVariable>();
    private List<DynamicalForce> forces = new ArrayList<DynamicalForce>();
    private HashMap<String, DynamicalVariable> varMap = new HashMap();
    private HashMap<String, DynamicalForce> forceMap = new HashMap();
    private double currentTime = 0.0;
    private double startTime = 0.0;
    private double timeStep = 0.0;
    private double storedCurrentTime = 0.0;
    private double storedStartTime = 0.0;

    public static void main(String[] stringArray) {
        DynamicalSystem dynamicalSystem = new DynamicalSystem(0.0, 0.001);
        double d = 0.027;
        double d2 = 5.4E-4;
        dynamicalSystem.addVariable("susceptibles", 330.0);
        dynamicalSystem.addVariable("infecteds", 23325.0);
        dynamicalSystem.addVariable("recovereds", 4524.0);
        dynamicalSystem.addVariable("total", 28179.0);
        dynamicalSystem.addForce("contact", d, new String[]{"infecteds", "susceptibles"}, new String[]{"total"}, "susceptibles", "infecteds");
        dynamicalSystem.addForce("recovery", d2, new String[]{"infecteds"}, new String[0], "infecteds", "recovereds");
        double d3 = dynamicalSystem.getValue("susceptibles", 500.0);
        System.out.println(d3);
        dynamicalSystem.print(0.0, 500.0, 10.0);
    }

    public DynamicalSystem(double d, double d2) {
        this.currentTime = this.startTime = d;
        this.timeStep = d2;
    }

    public double getTime() {
        return this.currentTime;
    }

    public int size() {
        return this.variables.size();
    }

    public DynamicalVariable getVar(String string) {
        return this.varMap.get(string);
    }

    public DynamicalForce getForce(String string) {
        return this.forceMap.get(string);
    }

    public void resetVar(String string, double d) {
        DynamicalVariable dynamicalVariable = this.getVar(string);
        dynamicalVariable.reset(this.startTime, d);
    }

    public void resetForce(String string, double d) {
        DynamicalForce dynamicalForce = this.getForce(string);
        dynamicalForce.reset(d);
    }

    public void resetTime() {
        this.currentTime = this.startTime;
    }

    public void store() {
        this.storedCurrentTime = this.currentTime;
        this.storedStartTime = this.startTime;
        for (DynamicalVariable object : this.variables) {
            object.store();
        }
        for (DynamicalForce dynamicalForce : this.forces) {
            dynamicalForce.store();
        }
    }

    public void restore() {
        this.currentTime = this.storedCurrentTime;
        this.startTime = this.storedStartTime;
        for (DynamicalVariable object : this.variables) {
            object.restore();
        }
        for (DynamicalForce dynamicalForce : this.forces) {
            dynamicalForce.restore();
        }
    }

    public double getValue(int n, double d) {
        while (this.currentTime < d) {
            this.step();
        }
        DynamicalVariable dynamicalVariable = this.variables.get(n);
        return dynamicalVariable.getValue(d);
    }

    public double getValue(String string, double d) {
        while (this.currentTime < d) {
            this.step();
        }
        DynamicalVariable dynamicalVariable = this.getVar(string);
        return dynamicalVariable.getValue(d);
    }

    public double getIntegral(int n, double d, double d2) {
        while (this.currentTime < d2) {
            this.step();
        }
        DynamicalVariable dynamicalVariable = this.variables.get(n);
        return dynamicalVariable.getIntegral(d, d2);
    }

    public double getIntegral(String string, double d, double d2) {
        while (this.currentTime < d2) {
            this.step();
        }
        DynamicalVariable dynamicalVariable = this.getVar(string);
        return dynamicalVariable.getIntegral(d, d2);
    }

    public double getAverage(int n, double d, double d2) {
        while (this.currentTime < d2) {
            this.step();
        }
        DynamicalVariable dynamicalVariable = this.variables.get(n);
        return dynamicalVariable.getAverage(d, d2);
    }

    public double getAverage(String string, double d, double d2) {
        while (this.currentTime < d2) {
            this.step();
        }
        DynamicalVariable dynamicalVariable = this.getVar(string);
        return dynamicalVariable.getAverage(d, d2);
    }

    public void addVariable(String string, double d) {
        DynamicalVariable dynamicalVariable = new DynamicalVariable(string, this.startTime, d);
        this.varMap.put(string, dynamicalVariable);
        this.variables.add(dynamicalVariable);
    }

    public void addForce(String string, double d, String[] stringArray, String[] stringArray2, String string2, String string3) {
        DynamicalForce dynamicalForce = new DynamicalForce(string, d, this.getVar(string2), this.getVar(string3));
        for (String string4 : stringArray) {
            dynamicalForce.addMultiplier(this.getVar(string4));
        }
        for (String string4 : stringArray2) {
            dynamicalForce.addDivisor(this.getVar(string4));
        }
        this.forceMap.put(string, dynamicalForce);
        this.forces.add(dynamicalForce);
    }

    public void step() {
        for (DynamicalForce object : this.forces) {
            object.modCurrentValue(this.currentTime, this.timeStep);
        }
        for (DynamicalVariable dynamicalVariable : this.variables) {
            dynamicalVariable.modCurrentTime(this.timeStep);
            dynamicalVariable.pushCurrentState();
        }
        this.currentTime += this.timeStep;
    }

    public void print(double d, double d2, double d3) {
        System.out.print("time");
        for (DynamicalVariable dynamicalVariable : this.variables) {
            System.out.print("\t" + dynamicalVariable.getName());
        }
        System.out.println();
        for (double d4 = d; d4 <= d2; d4 += d3) {
            System.out.printf("%.3f", d4);
            for (DynamicalVariable dynamicalVariable : this.variables) {
                System.out.printf("\t%.3f", dynamicalVariable.getValue(d4));
            }
            System.out.println();
        }
    }

    public String printValues(String string, double d, double d2, double d3) {
        String string2 = "";
        DynamicalVariable dynamicalVariable = this.getVar(string);
        for (double d4 = d; d4 <= d2; d4 += d3) {
            double d5 = dynamicalVariable.getValue(d4);
            string2 = string2 + "\t";
            string2 = string2 + Double.toString(d5);
        }
        return string2;
    }
}

