/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.model;

import dr.inference.model.MatrixParameter;
import dr.inference.model.MatrixParameterInterface;
import dr.inference.model.Parameter;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;
import java.util.ArrayList;
import java.util.List;

public class CompoundMatrixParameter
extends MatrixParameter {
    public static final String COMPOUND_MATRIX_PARAMETER = "compoundMatrixParameter";
    public static XMLObjectParser PARSER = new AbstractXMLObjectParser(){
        private final XMLSyntaxRule[] rules = new XMLSyntaxRule[]{new ElementRule(MatrixParameterInterface.class, 1, Integer.MAX_VALUE)};

        @Override
        public String getParserName() {
            return CompoundMatrixParameter.COMPOUND_MATRIX_PARAMETER;
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            ArrayList<MatrixParameterInterface> arrayList = new ArrayList<MatrixParameterInterface>();
            for (int i = 0; i < xMLObject.getChildCount(); ++i) {
                arrayList.add((MatrixParameterInterface)xMLObject.getChild(i));
            }
            String string = xMLObject.hasId() ? xMLObject.getId() : null;
            return new CompoundMatrixParameter(string, arrayList);
        }

        @Override
        public String getParserDescription() {
            return "A compound matrix parameter constructed from its component parameters.";
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }

        @Override
        public Class getReturnType() {
            return CompoundMatrixParameter.class;
        }
    };

    public CompoundMatrixParameter(String string, List<MatrixParameterInterface> list) {
        super(string, CompoundMatrixParameter.compoundMatrices(list));
    }

    private static Parameter[] compoundMatrices(List<MatrixParameterInterface> list) {
        int n = 0;
        for (MatrixParameterInterface matrixParameterInterface : list) {
            n += matrixParameterInterface.getColumnDimension();
        }
        Parameter[] parameterArray = new Parameter[n];
        int n2 = 0;
        for (MatrixParameterInterface matrixParameterInterface : list) {
            for (int i = 0; i < matrixParameterInterface.getColumnDimension(); ++i) {
                parameterArray[n2] = matrixParameterInterface.getParameter(i);
                ++n2;
            }
        }
        return parameterArray;
    }
}

