/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.speciation;

import dr.evolution.tree.NodeRef;
import dr.evolution.tree.Tree;
import dr.evolution.util.Taxon;
import dr.evolution.util.Units;
import dr.evomodel.speciation.CalibrationPoints;
import dr.evomodel.speciation.SpeciationModel;
import java.util.Set;

public abstract class UltrametricSpeciationModel
extends SpeciationModel
implements Units {
    public UltrametricSpeciationModel(String string, Units.Type type) {
        super(string, type);
    }

    public abstract double logTreeProbability(int var1);

    public abstract double logNodeProbability(Tree var1, NodeRef var2);

    public boolean analyticalMarginalOK() {
        return false;
    }

    public double getMarginal(Tree tree, CalibrationPoints calibrationPoints) {
        return calibrationPoints.getCorrection(tree, -1.0);
    }

    public abstract boolean includeExternalNodesInLikelihoodCalculation();

    @Override
    public final double calculateTreeLogLikelihood(Tree tree) {
        int n;
        int n2 = tree.getExternalNodeCount();
        double d = this.logTreeProbability(n2);
        for (n = 0; n < tree.getInternalNodeCount(); ++n) {
            d += this.logNodeProbability(tree, tree.getInternalNode(n));
        }
        if (this.includeExternalNodesInLikelihoodCalculation()) {
            for (n = 0; n < n2; ++n) {
                d += this.logNodeProbability(tree, tree.getExternalNode(n));
            }
        }
        return d;
    }

    @Override
    public double calculateTreeLogLikelihood(Tree tree, Set<Taxon> set) {
        int n = tree.getExternalNodeCount() - set.size();
        double[] dArray = new double[]{this.logTreeProbability(n)};
        this.calculateNodeLogLikelihood(tree, tree.getRoot(), set, dArray);
        return dArray[0];
    }

    private int calculateNodeLogLikelihood(Tree tree, NodeRef nodeRef, Set<Taxon> set, double[] dArray) {
        if (tree.isExternal(nodeRef)) {
            if (!set.contains(tree.getNodeTaxon(nodeRef))) {
                if (this.includeExternalNodesInLikelihoodCalculation()) {
                    dArray[0] = dArray[0] + this.logNodeProbability(tree, nodeRef);
                }
                return 1;
            }
            return 0;
        }
        int n = 0;
        for (int i = 0; i < tree.getChildCount(nodeRef); ++i) {
            NodeRef nodeRef2 = tree.getChild(nodeRef, i);
            n += this.calculateNodeLogLikelihood(tree, nodeRef2, set, dArray);
        }
        if (n == 2) {
            dArray[0] = dArray[0] + this.logNodeProbability(tree, nodeRef);
        }
        return n > 0 ? 1 : 0;
    }

    @Override
    public double calculateTreeLogLikelihood(Tree tree, CalibrationPoints calibrationPoints) {
        double d = this.calculateTreeLogLikelihood(tree);
        double d2 = this.getMarginal(tree, calibrationPoints);
        return d += d2;
    }
}

