/*
 * Decompiled with CFR 0.152.
 */
package dr.geo;

import java.util.List;
import java.util.StringTokenizer;
import org.jdom.Element;

public class Polygon {
    public static final String POLYGON = "polygon";
    public static final String CLOSED = "closed";
    public static final String COORDINATES = "coordinates";
    protected double[] x;
    protected double[] y;
    protected double[] z;
    protected double[] t;
    protected int length;
    private boolean planarInZ;

    public Polygon(Element element) {
        boolean bl = Boolean.valueOf(element.getAttributeValue(CLOSED));
        List list = element.getChildren();
        for (int i = 0; i < list.size(); ++i) {
            Element element2 = (Element)list.get(i);
            if (!element2.getName().equals(COORDINATES)) continue;
            String string = element2.getTextTrim();
            StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
            int n = stringTokenizer.countTokens();
            this.x = new double[n];
            this.y = new double[n];
            this.z = new double[n];
            this.length = this.x.length - 1;
            for (int j = 0; j < n; ++j) {
                String string2 = stringTokenizer.nextToken();
                StringTokenizer stringTokenizer2 = new StringTokenizer(string2, ",");
                if (stringTokenizer2.countTokens() != 3) {
                    throw new IllegalArgumentException("All KML coordinates must contain (X,Y,Z) values.  Three dimensions not found in element '" + string2 + "'");
                }
                this.x[j] = Double.valueOf(stringTokenizer2.nextToken());
                this.y[j] = Double.valueOf(stringTokenizer2.nextToken());
                this.z[j] = Double.valueOf(stringTokenizer2.nextToken());
            }
        }
        this.planarInZ = this.isPlanarInZ();
    }

    private boolean isPlanarInZ() {
        double d = this.z[0];
        boolean bl = true;
        for (int i = 0; i < this.length; ++i) {
            if (d == this.z[i]) continue;
            bl = false;
            break;
        }
        return bl;
    }

    public boolean contains2DPoint(double d, double d2) {
        if (!this.planarInZ) {
            throw new RuntimeException("Only 2D polygons are currently implemented");
        }
        boolean bl = false;
        int n = 0;
        int n2 = this.length - 1;
        while (n < this.length) {
            if ((this.y[n] <= d2 && d2 < this.y[n2] || this.y[n2] <= d2 && d2 < this.y[n]) && d < (this.x[n2] - this.x[n]) * (d2 - this.y[n]) / (this.y[n2] - this.y[n]) + this.x[n]) {
                bl = !bl;
            }
            n2 = n++;
        }
        return bl;
    }
}

