% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/choosePositions.BchronologyRun.R
\name{choosePositions}
\alias{choosePositions}
\title{Compute positions to date next which result in maximal decrease of chronological uncertainty}
\usage{
choosePositions(bchrRun, N = 1, newSds = 30, newThicknesses = 0,
  positions = bchrRun$predictPositions, newCalCurve = "intcal13",
  newOutlierProb = 0.05, level = 0.5, plot = TRUE, count = 1,
  linesAt = NULL)
}
\arguments{
\item{bchrRun}{A run of the current chronology as output from \code{\link{Bchronology}}}

\item{N}{The number of new positions required}

\item{newSds}{The new standard deviations of the psuedo-added dates}

\item{newThicknesses}{The new thicknesses of the psuedo-added dates}

\item{positions}{The positions allowed to estimate the new positions to date. Defaults to the value of \code{predictPositions} from the 
\code{\link{Bchronology}} run}

\item{newCalCurve}{The new calibration curve of the psuedo-added dates}

\item{newOutlierProb}{The new outlier probabilities of the psuedo-added dates}

\item{level}{The confidence level required for minimising the uncertainty. Defaults to 50\%. (Note: this will be estimated more robustly than the 95\% level)}

\item{plot}{Whether to plot the chronologies as they are produced}

\item{count}{Counter function (not for use other than by the function itself)}

\item{linesAt}{Horizontal line positions (not for use other than by the function itself)}
}
\value{
Some plots and the positions to date next
}
\description{
This function finds, for a given current chronology, created via
\code{\link{Bchronology}}, which positions (depths) to date next
If N = 1 it just finds the position with the biggest uncertainty
If N>1 it puts a date at the N = 1 position and re-runs 
\code{\link{Bchronology}} with the extra psuedo date. It uses the 
\code{\link{unCalibrate}} function with the un-calibrated age estimated 
at the median of the chronology and the sd as specified via the 
\code{newSds} argument. Other arguments specify the new thicknesses, 
calibration curves, and outlier probabilities for newly inserted psuedo-dates.
}
\examples{
\donttest{
data(Glendalough)
GlenOut = Bchronology(ages=Glendalough$ages,
                      ageSds=Glendalough$ageSds,
                      calCurves=Glendalough$calCurves,
                      positions=Glendalough$position,
                      positionThicknesses=Glendalough$thickness,
                      ids=Glendalough$id,
                      predictPositions=seq(0,1500,by=10))

# Find out which two positions (depths) to date if we have room for two more dates
# Here going to choose 3 new positions to date
newPositions = choosePositions(GlenOut, N = 3)
print(newPositions)
}
}
\seealso{
\code{\link{Bchronology}} for the main function to create chronologies, \code{\link{unCalibrate}} for the ability to invert calendar dates for a given calibration curve.
}
