% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chi_square_goodness_of_fit.R
\name{Chi_square_goodness_of_fit_in_case_of_MRMC_Posterior_Mean}
\alias{Chi_square_goodness_of_fit_in_case_of_MRMC_Posterior_Mean}
\title{Chi square \eqn{\chi^2} in the case
 of MRMC at the pair of given data
  and each MCMC samples \eqn{(\theta_i)_{i=1}^N }.}
\usage{
Chi_square_goodness_of_fit_in_case_of_MRMC_Posterior_Mean(StanS4class,
  summary = TRUE, dl_is_an_array_of_C_only_and_not_C_M_Q = TRUE)
}
\arguments{
\item{StanS4class}{An S4 object of class \emph{\code{ \link{stanfitExtended}}} which is an inherited class from the S4 class  \code{\link[rstan]{stanfit}}  that can be passed to the \code{\link{DrawCurves}()}, \code{\link{ppp}()}  and ... etc}

\item{summary}{Logical: \code{TRUE} of \code{FALSE}. Whether to print the verbose summary, i.e., logical; If \code{TRUE} then verbose summary is printed in the \R console. If \code{FALSE}, the output is minimal. I regret, this variable name should be verbose.}

\item{dl_is_an_array_of_C_only_and_not_C_M_Q}{A Boolean, if \code{TRUE},
then false rate \code{lambda} simply
denoted by \code{l} in \R script ( \eqn{\lambda} )
is an vector \code{l[C]}. If false, then the false
 alarm rate is an array \code{l[C,M,Q]}.}
}
\value{
A list, calculated by each modality reader and cofidence level, and MCMC samples.
 A one the component of list contains \{ \eqn{\chi^2(Data|\theta_i)} ; i= 1,2,3,...n\}, where \eqn{n} is the number of MCMC iterations.

Each component
of list isan array
 whose index indicats  \code{[MCMC, Confidence, Modality, Reader]  }.

Each component of list is
  \code{an array whose index indicats [MCMC, C, M, Q]}.

To be passed to the calculation of Posterior predictive p value,
I need the sum of return value,
that is, sum of C,M,Q and resulting quantities
construct a vetor whose length is a same as the number of MCMC iterations.
I love you. I need you. So, to calculate such quantites,
 the author .... will make a new function.


 Also, retains the posterior mean of chi square:


   \deqn{\chi^2(Data)  = \int \chi^2(Data|\theta) d  \theta}
}
\description{
Revised 2019 Oct 16.


In the following, we explain what this function calculates.

Let \eqn{\chi^2(y|\theta)} be a chi square goodness of fit statistics
of our hierarchical Bayesian Model:

\deqn{\chi^2(D|\theta) := \sum_{r=1}^R \sum_{m=1}^M \sum_{c=1}^C \biggr( \frac{[ H_{c,m,r}-N_L\times p_{c,m,r}]^2}{N_L\times p_{c,m,r}}+\frac{[F_{c,m,r}-(\lambda _{c} -\lambda _{c+1} )\times N_{L}]^2}{(\lambda_{c} -\lambda_{c+1} )\times N_{L} }\biggr).}

where  a dataset \eqn{D} means the
pair of False Positives and True
Positives  \eqn{ (F_{c,m,r}, H_{c,m,r}) } and
 model parameter \eqn{\theta}.

So, the chi square has two terms,
former is the difference of hit
and its expectation and the lator
 is that of false alarm, thus
  we calculates each terms separately
   and retains these in the return values.



In this function, we calculates the following two:


\describe{
\item{ \strong{A vector}    }{


Let us denotes a collection of
posterior MCMC samples for a given dataset \eqn{D} by

\deqn{   \theta_1 ,   \theta_2 ,   \theta_3,    \cdots ,    \theta_N.}
Then the function calculates the following vector obtained by substituing the MCMC samples into the above chi square equation:

     \deqn{ \chi^2(D|\theta_1),}
     \deqn{ \chi^2(D|\theta_2),}
     \deqn{ \chi^2(D|\theta_3),}
     \deqn{          :         }
     \deqn{          :         }
     \deqn{ \chi^2(D|\theta_N).}


}

\item{ \strong{A mean of the above vector over all MCMC samples}    }{


Also, using the above vector, the function evaluates the posterior mean of these chi squares, namely,


      \deqn{\frac{1}{N} \sum _i ^N \chi^2(D|\theta_i),}

which is an approximation of the following posterior integral;


      \deqn{\int   \chi^2(D|\theta)\pi(\theta|D) d\theta,}

where \eqn{\pi(\theta|D)} denotes the posterior probability.


}

}
}
\details{
This function use the
vectorizations and further techinical programming.
When the author review this, I
 find my past work is great,...
 I forget that I made this.
But this function is great.
}
\examples{


\donttest{

#----------------------------------------------------------------------------------------
#            1) Create a fitted model object with data named only one word dd
#----------------------------------------------------------------------------------------



                          fit <- fit_Bayesian_FROC(dd )



#----------------------------------------------------------------------------------------
#            2) Calculate a chi square and meta data
#----------------------------------------------------------------------------------------



            a <- Chi_square_goodness_of_fit_in_case_of_MRMC_Posterior_Mean(fit)



#----------------------------------------------------------------------------------------
#            3) Extract a chi.square
#----------------------------------------------------------------------------------------






                              chi.square  <- a$chi.square





# Revised 2019 August 19 with great love and peace and hate of the notion of p values.
# I hate all montagues and thee.


}# donttest



}
