% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.BayesSUR.R
\name{plot.BayesSUR}
\alias{plot.BayesSUR}
\title{create a selection of plots}
\usage{
\method{plot}{BayesSUR}(x, estimator = NULL, type = NULL, ...)
}
\arguments{
\item{x}{an object of class \code{BayesSUR}}

\item{estimator}{It is in \code{c(NULL, 'beta', 'gamma', 'Gy', 'logP', 'CPO')} 
and works by combining with argument \code{type}.
\itemize{
  \item If \code{estimator} is in \code{c("beta", "gamma", "Gy")} and 
  argument \code{type="heatmap"}, it prints heatmaps of the specified 
  estimator in \code{estimator} by a call to to function 
  \code{plotEstimator()} for more other arguments.
  \item If \code{estimator="Gy"} and argument \code{type="graph"}, it prints 
  a structure graph of \code{"Gy"} by a call to function \code{plotGraph()} 
  for more other arguments.
  \item If \code{estimator=c("gamma", "Gy")} and argument 
  \code{type="network"}, it prints the estimated network between the 
  response variables and predictors with nonzero coefficients by a call to 
  function \code{plotMCMCdiag()} for more other arguments.
  \item If \code{estimator=NULL} (default) and \code{type=NULL} (default), 
  it interactively prints the plots of estimators (i.e., beta, gamma 
  and (or) Gy), response graph Gy, network, Manhattan and MCMC diagnostics.
}}

\item{type}{It is one of \code{NULL}, \code{"heatmap"}, \code{"graph"}, 
\code{"network"}, \code{"Manhattan"} and \code{"diagnostics"}, and works by 
combining with argument \code{estimator}.
\itemize{
  \item If \code{type="Manhattan"} and argument \code{estimator="gamma"}, 
  it prints Manhattan-like plots for marginal posterior inclusion 
  probabilities (mPIP) and numbers of associated response variables for 
  individual predictors by a call to function \code{plotManhattan()} for 
  more other arguments.
  \item If \code{type="diagnostics"} and argument \code{estimator="logP"} 
  it shows trace plots and diagnostic density plots of a fitted model by a 
  call to function \code{plotMCMCdiag()} for more other arguments.
  \item If \code{type="diagnostics"} and argument \code{estimator="CPO"}, 
  it shows the conditional predictive ordinate (CPO) for each individual of 
  a fitted model by a call to function \code{plotCPO()} for more other arguments.
}}

\item{...}{other arguments, see functions \code{plotEstimator()}, 
\code{plotGraph()}, \code{plotNetwork()}, \code{plotManhattan()}, 
\code{plotMCMCdiag()} or \code{plotCPO()}}
}
\description{
plot method for class \code{BayesSUR}. This is the main plot function to be 
called by the user. This function calls one or several of the following 
functions: \code{plotEstimator()}, \code{plotGraph()}, \code{plotMCMCdiag()}, 
\code{plotManhattan()}, \code{plotNetwork()}, \code{plotCPO()}.
}
\examples{
data("exampleEQTL", package = "BayesSUR")
hyperpar <- list(a_w = 2, b_w = 5)

set.seed(9173)
fit <- BayesSUR(
  Y = exampleEQTL[["blockList"]][[1]],
  X = exampleEQTL[["blockList"]][[2]],
  data = exampleEQTL[["data"]], outFilePath = tempdir(),
  nIter = 100, burnin = 0, nChains = 2, gammaPrior = "hotspot",
  hyperpar = hyperpar, tmpFolder = "tmp/"
)

## check output
\dontrun{
# Show the interactive plots. Note that it needs at least 2000*(nbloc+1) iterations
# for the diagnostic plots where nbloc=3 by default
plot(fit)
}

## plot heatmaps of the estimated beta, gamma and Gy
plot(fit, estimator = c("beta", "gamma", "Gy"), type = "heatmap")

## plot estimated graph of responses Gy
plot(fit, estimator = "Gy", type = "graph")

## plot network between response variables and associated predictors
plot(fit, estimator = c("gamma", "Gy"), type = "network")

## print Manhattan-like plots
plot(fit, estimator = "gamma", type = "Manhattan")

## print MCMC diagnostic plots
plot(fit, estimator = "logP", type = "diagnostics")

}
