% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcmcReg.R
\name{mcmcReg}
\alias{mcmcReg}
\title{LaTeX or HTML regression tables for MCMC Output}
\usage{
mcmcReg(mod, pars = NULL, pointest = "mean", ci = 0.95,
  hpdi = FALSE, coefnames = NULL, gof = numeric(0),
  gofnames = character(0), format = "latex", file, regex = FALSE,
  ...)
}
\arguments{
\item{mod}{Bayesian model object generated by R2jags, rjags, R2WinBUGS, R2OpenBUGS, 
MCMCpack, rstan, rstanarm, and brms, or a list of model objects of the same class.}

\item{pars}{a scalar or vector of the parameters you wish to include in the table.
By default, \code{mcmcReg} includes all parameters saved in a model object. If a
model has lots of samples and lots of saved parameters, not explicitly specifying
a limited number of parameters to include via \code{pars} may take a long time.
\code{pars} can either be a vector with the specific parameters to be included
in the table e.g. \code{pars = c("beta[1]", "beta[2]", "beta[3]")}, or they can
be partial names that will be matched using regular expressions e.g.
\code{pars = "beta"} if \code{regex = TRUE}. Both of these will include
\code{beta[1]}, \code{beta[2]}, and \code{beta[3]} in the table. When
combining models with different parameters in one table, this argument also
accepts a list the length of the number of models.}

\item{pointest}{a character indicating whether to use the mean or median for
point estimates in the table.}

\item{ci}{a scalar indicating the confidence level of the uncertainty intervals.}

\item{hpdi}{a logical indicating whether to use highest posterior density intervals
or equal tailed credible intervals to capture uncertainty.}

\item{coefnames}{an optional vector or list of vectors containing parameter
names for each model. If there are multiple models, the list must have the same
number of elements as there are models, and the vector of names in each list
element must match the number of parameters. If not supplied, the function
will use the parameter names in the model object(s). Note that this replaces
the standard \code{custom.coef.names} argument in \code{\link[texreg]{texreg}} because there is no
\code{extract} method for MCMC model objects, and many MCMC model objects do not
have unique parameter names.}

\item{gof}{a named list of goodness of fit statistics, or a list of such lists.}

\item{gofnames}{an optional vector or list of vectors containing
goodness of fit statistic names for each model. Like \code{coefnames} in this function
(which replaces the \code{custom.coef.names} argument in \code{\link[texreg]{texreg}}),
\code{gofnames} replaces the standard \code{custom.gof.names} argument in
\code{\link[texreg]{texreg}}. If 
there are multiple models, the list must have the same number of elements as
there are models, and the vector of names in each list element must match the
number of goodness of fit statistics.}

\item{format}{a character indicating \code{latex} or \code{html} output.}

\item{file}{optional file name to write table to file instead of printing to
console.}

\item{regex}{use regular expression matching with \code{pars}?}

\item{...}{optional arguments to \code{\link[texreg]{texreg}}.}
}
\value{
A formatted regression table in LaTeX or HTML format.
}
\description{
This function creates LaTeX or HTML regression tables for MCMC Output using 
the \code{\link[texreg]{texreg}} function from the \code{\link[texreg:texreg-package]{texreg}} R package.
}
\details{
This function creates LaTeX or HTML regression tables for MCMC Output using 
the \code{texreg} function from the \code{\link[texreg:texreg-package]{texreg}} R package

If using \code{custom.coef.map} with more than one model, you should rename
the parameters in the model objects to ensure that different parameters with the
same subscript are not conflated by \code{texreg} e.g. \code{beta[1]} could represent age
in one model and income in another, and \code{texreg} would combine the two if you
do not rename \code{beta[1]} to more informative names in the model objects.

If \code{mod} is a \code{brmsfit} object or list of \code{brmsfit} objects, note that the
default \code{brms} names for coefficients are \code{b_Intercept} and \code{b}, so both of
these should be included in \code{par} if you wish to include the intercept in the
table.
}
\examples{
\dontshow{.old_wd <- setwd(tempdir())}
\donttest{
## simulating data
set.seed(123456)
b0 <- 0.2 # true value for the intercept
b1 <- 0.5 # true value for first beta
b2 <- 0.7 # true value for second beta
n <- 500 # sample size
X1 <- runif(n, -1, 1)
X2 <- runif(n, -1, 1)
Z <- b0 + b1 * X1 + b2 * X2
pr <- 1 / (1 + exp(-Z)) # inv logit function
Y <- rbinom(n, 1, pr)
data <- data.frame(cbind(X1, X2, Y))

## formatting the data for jags
datjags <- as.list(data)
datjags$N <- length(datjags$Y)

## creating jags model
model <- function()  {

  for(i in 1:N){
    Y[i] ~ dbern(p[i])  ## Bernoulli distribution of y_i
    logit(p[i]) <- mu[i]    ## Logit link function
    mu[i] <- b[1] +
      b[2] * X1[i] +
      b[3] * X2[i]
  }

  for(j in 1:3){
    b[j] ~ dnorm(0, 0.001) ## Use a coefficient vector for simplicity
  }

}

params <- c("b")
inits1 <- list("b" = rep(0, 3))
inits2 <- list("b" = rep(0, 3))
inits <- list(inits1, inits2)

## fitting the model with R2jags
set.seed(123)
fit <- R2jags::jags(data = datjags, inits = inits,
                    parameters.to.save = params, n.chains = 2, n.iter = 2000,
                    n.burnin = 1000, model.file = model)

## generating regression table with all parameters
mcmcReg(fit)

## generating regression table with only betas and custom coefficent names
mcmcReg(fit, pars = c('b'), coefnames = c('Variable 1', 'Variable 2',
                                                  'Variable 3'))
## generating regression tables with all betas and custom names
mcmcReg(fit, coefnames = c('Variable 1', 'Variable 2',
                                   'Variable 3', 'deviance'))
}

\dontshow{setwd(.old_wd)}
}
\author{
Rob Williams, \email{jayrobwilliams@gmail.com}
}
