% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/importObservations.R
\name{importObservations}
\alias{importObservations}
\title{Import Observed Mass Flow Rates}
\usage{
importObservations(file, header = FALSE, csv.params = NULL)
}
\arguments{
\item{file}{Character string containing the name of \code{*.csv} from file which data will be read.  See Details below for valid file structures.}

\item{header}{Logical indicating if the first row of \code{file} file contains header information.  Current implementation of \code{importObservations} discards this information.}

\item{csv.params}{List of arguments to be passed to \code{\link{read.csv}}}
}
\value{
Returns a list of data frames.  Each data frame is named according to the unique sample components specified in the second column of \code{file}.  This list object is intended to be used as the argument \code{y} for the \code{\link{BMB}} function.
}
\description{
Imports observed mass flow rates stored in a \code{*.csv} file and then organizes the data for use with the \code{\link{BMB}} function.
}
\details{
The purpose of this function is to make it easy to import and structure loosely organized data contained in a \code{*.csv} into a list for use as the \code{y} argument passed to the \code{\link{BMB}} function.
The entries in file must be organized as such:

\itemize{
\item The first column of \code{file} must contain an integer sample location. The value of this integer must correspond to the column number used to specify linear constraints in \code{\link{constrainProcess}}.  For example, data for a given component collected at sampling location \eqn{y_2} should be indicated with a \code{2} in the first column of \code{file} used with \code{importObservations}.  In the \code{file} used with \code{\link{constrainProcess}}, the linear constraint(s) on \eqn{y_2} are indicated in the second column.
\item The second column of \code{file} must contain sample component names.  \strong{This field is case sensitive}.  Ensure a given sample component is named consistently, including capitalization and spacing.
\item Columns 3 to \eqn{K+2} of \code{file} must contain observed mass flow rates for the \eqn{K} collected sample sets.  All observations located in the same column should be collected at the same time.
\item Sample components of interest must be specified for each location.  If a sample component is not detected at some locations, but is detected at others, this component should be included in \code{file} with a specified mass flow rate of 0, or a very small number.
}

\code{importObservations} reads the contents of \code{file}, sorts the sampling locations numerically, then creates a list of data frames.  Each data frame contains the data for a single sample component.
}
\examples{

 y <- importObservations(file = system.file("extdata", "twonode_example.csv",
                                      package = "BayesMassBal"),
                   header = TRUE, csv.params = list(sep = ";"))

## The linear constraints for this example data set are:
\donttest{C <- matrix(c(1,-1,0,-1,0,0,1,-1,0,-1), byrow = TRUE, ncol = 5, nrow = 2)}

## The X matrix for this data set can be found using:
\donttest{X <- constrainProcess(C = C)}
}
