% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_posterior_intervals.R
\name{compute_posterior_intervals.SMCMallows}
\alias{compute_posterior_intervals.SMCMallows}
\title{Compute posterior intervals}
\usage{
\method{compute_posterior_intervals}{SMCMallows}(
  model_fit,
  parameter = "alpha",
  level = 0.95,
  decimals = 3L,
  ...
)
}
\arguments{
\item{model_fit}{An object of class \code{SMCMallows}, returned from
\code{\link{smc_mallows_new_item_rank}} or
\code{\link{smc_mallows_new_users}}.}

\item{parameter}{Character string defining which parameter to compute
posterior intervals for. One of \code{"alpha"} or \code{"rho"}.}

\item{level}{Decimal number in \eqn{[0,1]} specifying the confidence level.
Defaults to \code{0.95}.}

\item{decimals}{Integer specifying the number of decimals to include in
posterior intervals and the mean and median. Defaults to \code{3}.}

\item{...}{Other arguments. Currently not used.}
}
\description{
This function computes posterior intervals based on the set of samples at the
last timepoint of the SMC algorithm.
}
\examples{
# Basic elements
data <- sushi_rankings[1:100, ]
n_items <- ncol(data)
leap_size <- floor(n_items / 5)
metric <- "footrule"
Time <- 20
N <- 100

# Prepare exact partition function
cardinalities <- prepare_partition_function(metric = metric,
                                            n_items = n_items)$cardinalities

# Performing SMC
smc_test <- smc_mallows_new_users(
  R_obs = data, type = "complete", n_items = n_items,
  metric = metric, leap_size = leap_size,
  N = N, Time = Time,
  cardinalities = cardinalities,
  mcmc_kernel_app = 5,
  num_new_obs = 5,
  alpha_prop_sd = 0.5,
  lambda = 0.15,
  alpha_max = 1e6
)

compute_posterior_intervals(smc_test, parameter = "rho")

compute_consensus(model_fit = smc_test, type = "CP")
compute_consensus(model_fit = smc_test, type = "MAP")

compute_posterior_intervals(smc_test, parameter = "alpha")
}
\seealso{
Other posterior quantities: 
\code{\link{assign_cluster}()},
\code{\link{compute_consensus.BayesMallows}()},
\code{\link{compute_consensus.SMCMallows}()},
\code{\link{compute_consensus}()},
\code{\link{compute_posterior_intervals.BayesMallows}()},
\code{\link{compute_posterior_intervals}()},
\code{\link{heat_plot}()},
\code{\link{plot.BayesMallows}()},
\code{\link{plot.SMCMallows}()},
\code{\link{plot_elbow}()},
\code{\link{plot_top_k}()},
\code{\link{predict_top_k}()},
\code{\link{print.BayesMallowsMixtures}()},
\code{\link{print.BayesMallows}()}
}
\concept{posterior quantities}
