% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{get_rank_distance}
\alias{get_rank_distance}
\title{Compute the Distance between two rankings}
\usage{
get_rank_distance(r1, r2, metric)
}
\arguments{
\item{r1}{A vector of ranks.}

\item{r2}{A vector of ranks.}

\item{metric}{A string. Available options are \code{"footrule"},
\code{"kendall"}, \code{"cayley"}, \code{"hamming"}, \code{"spearman"}, and \code{"ulam"}.}
}
\value{
A scalar.
}
\description{
Compute the distance between two rankings according to several metrics.
}
\details{
Note that the Spearman distance is the squared L2 norm, whereas
the footrule distance is the L1 norm.

The Ulam distance uses the SUBSET library developed by John Burkardt, available at http://people.sc.fsu.edu/~jburkardt/cpp_src/subset/subset.html.

The implementation of Cayley distance is based on a \code{C++} translation of \code{Rankcluster::distCayley} \insertCite{Grimonprez2016}{BayesMallows}.
}
\references{
\insertAllCited{}
}
\keyword{internal}
