% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{correction_kernel_pseudo}
\alias{correction_kernel_pseudo}
\title{Correction Kernel (pseudolikelihood)}
\usage{
correction_kernel_pseudo(
  current_ranking,
  observed_ranking,
  rho,
  alpha,
  n_items,
  metric
)
}
\arguments{
\item{current_ranking}{An complete rank sequence vector of  the proposed augmented ranking obtained from calculate_forward_probability function}

\item{observed_ranking}{An incomplete rank sequence vector of the original observed incomplete ranking which contains NAs}

\item{rho}{Numeric vector specifying the consensus ranking}

\item{alpha}{Numeric value of the scale parameter}

\item{n_items}{Integer is the number of items in a ranking}

\item{metric}{A character string specifying the distance metric to use in the
Bayesian Mallows Model. Available options are \code{"footrule"},
\code{"spearman"}, \code{"cayley"}, \code{"hamming"}, \code{"kendall"}, and
\code{"ulam"}.}
}
\value{
list containing R_obs, the proposed 'corrected' augmented ranking that is compatible with the new observed ranking for a user, and
        forward_auxiliary_ranking_probability, a numerical value for the probability of correcting the ranking to be compatible with R_obs.
}
\description{
Function to determine if the augmented ranking is compatible with the new observed partial ranking.
If it is not, the we create a new augmentation using the pseudolikelihood approach and calculate the augmentation probability.
}
