% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_map_consensus.R
\name{compute_map_consensus}
\alias{compute_map_consensus}
\title{Maximum a Posterior Consensus Ranking}
\usage{
compute_map_consensus(model_fit, burnin = model_fit$burnin)
}
\arguments{
\item{model_fit}{An object of type \code{BayesMallows}, returned from
\code{\link{compute_mallows}}.}

\item{burnin}{A numeric value specifying the number of iterations
to discard as burn-in. Defaults to \code{model_fit$burnin}, and must be
provided if \code{model_fit$burnin} does not exist. See \code{\link{assess_convergence}}.}
}
\description{
Compute the maximum a posterior consensus ranking. If a mixture model
is supplied, the maximum a posterior consensus ranking for each mixture
is returned.
}
\examples{
# The example datasets potato_visual and potato_weighing contain complete
# rankings of 20 items, by 12 assessors. We first analyse these using the Mallows
# model:
model_fit <- compute_mallows(potato_visual)

# Se the documentation to compute_mallows for how to assess the convergence of the algorithm
# Having chosen burin = 1000, we compute posterior intervals
model_fit$burnin <- 1000
# We then compute the MAP consensus.
compute_map_consensus(model_fit)

\dontrun{
  # CLUSTERWISE MAP CONSENSUS
  # We can run a mixture of Mallows models, using the n_clusters argument
  # We use the sushi example data. See the documentation of compute_mallows for a more elaborate
  # example
  model_fit <- compute_mallows(sushi_rankings, n_clusters = 5)
  # Keeping the burnin at 1000, we can compute the MAP consensus per cluster
  model_fit$burnin <- 1000
  map_consensus_df <- compute_map_consensus(model_fit)
  # Using dplyr::select and tidyr::spread we can now make a table
  # which shows the ranking in each cluster:
  library(dplyr)
  library(tidyr)
  map_consensus_df \%>\%
    select(-probability) \%>\%
    spread(key = cluster, value = item)
}

\dontrun{
  # MAP CONSENSUS FOR PAIRWISE PREFENCE DATA
  # We use the example dataset with beach preferences.
  model_fit <- compute_mallows(preferences = beach_preferences)
  # We set burnin = 1000
  model_fit$burnin <- 1000
  # We now compute the MAP consensus
  map_consensus_df <- compute_map_consensus(model_fit)
}

}
