% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Est_quant.R
\name{LN_Quant}
\alias{LN_Quant}
\title{Bayesian estimate of the log-normal quantiles}
\usage{
LN_Quant(
  x,
  quant,
  method = "weak_inf",
  x_transf = TRUE,
  guess_s2 = NULL,
  CI = TRUE,
  alpha_CI = 0.05,
  type_CI = "two-sided",
  method_CI = "exact",
  rel_tol_CI = 1e-05,
  nrep_CI = 1e+06
)
}
\arguments{
\item{x}{Vector of data used to estimate the quantile.}

\item{quant}{Number between 0 and 1 that indicates the quantile of interest.}

\item{method}{String that indicates the prior setting to adopt. Choosing \code{"weak_inf"}
a weakly informative prior setting is adopted, whereas selecting
\code{"optimal"} the hyperparameters are fixed trough a numerical optimization algorithm
aimed at minimizing the frequentist MSE.}

\item{x_transf}{Logical. If \code{TRUE}, the \code{x} vector is assumed already log-transformed.}

\item{guess_s2}{Specification of a guess for the variance if available. If not, the sample estimate is used.}

\item{CI}{Logical. With the default choice \code{TRUE}, the posterior credibility interval is computed.}

\item{alpha_CI}{Level of alpha that determines the credibility (1-\code{alpha_CI}) of the posterior interval.}

\item{type_CI}{String that indicates the type of interval to compute: \code{"two-sided"} (default),
\code{"UCL"} (i.e. Upper Credible Limit) for upper one-sided intervals  or \code{"LCL"} (i.e. Lower
Credible Limit) for lower one-sided intervals.}

\item{method_CI}{String that indicates if the limits should be computed through the logSMNG
quantile function \code{\link{qlSMNG}} (option \code{"exact"}, default), or by randomly generating a sample
(\code{"simulation"}) using the function \code{\link{rlSMNG}}.}

\item{rel_tol_CI}{Level of relative tolerance required for the \code{integrate} procedure or for the infinite sum.
Default set to \code{1e-5}.}

\item{nrep_CI}{Number of simulations in case of \code{method="simulation"}.}
}
\value{
The function returns the prior parameters and their posterior values, summary statistics of the log-scale parameters and the estimate of the specified quantile:
the posterior mean and variance are provided by default. Moreover, the user can control the computation of posterior intervals.
}
\description{
This function produces an estimate for the log-normal distribution quantile of fixed level \code{quant}.
}
\details{
The function allows to carry out Bayesian inference for the unconditional quantiles of a sample that is assumed log-normally distributed.

A generalized inverse Gaussian prior is assumed for the variance in the log scale \eqn{\sigma^2}, whereas a
flat improper prior is assumed for the mean in the log scale \eqn{\xi}.

Two alternative hyperparamters setting are implemented (choice controlled by the argument \code{method}): a weakly
informative proposal and an optimal one.
}
\examples{
library(BayesLN)
data("EPA09")
LN_Quant(x = EPA09, quant = 0.95, method = "optimal", CI = FALSE)
LN_Quant(x = EPA09, quant = 0.95, method = "weak_inf",
        alpha_CI = 0.05, type_CI = "UCL")

}
