% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fastGPfit.R
\name{GP.summary}
\alias{GP.summary}
\title{Summary of posterior inference on the Bayesian Gaussian process regression model}
\usage{
GP.summary(GP_fit)
}
\arguments{
\item{GP_fit}{An output object of function \link{GP.Bayes.fit} or \link{GP.fast.Bayes.fit}. Please refer to them for details.}
}
\value{
A list object consisting of the following elements:
\describe{
\item{mean}{A list object for posterior mean of the target function,consisting of two elements (f is a vector for function values; x is
  a vector or matrix for points evaluated).}
  \item{work_x}{A matrix of real numbers for the standardized grid points for the model fitting.
  It has the same dimension as "x".}
   \item{uci}{A list object for 95\% upper bound of the creditible interval
   (uci) of the taget function,
  consisting of two elements (f is a vector for function values;
   x is a vector or matrix for points evaluated).}
  \item{lci}{A list object for 95\% lower bound of the creditibel interval (lci) of the taget function,
  consisting of two elements (f is a vector for function values; x is
  a vector or matrix for points evaluated).}
  \item{sigma2}{A vector of posteror mean, the 95\% lcl and ucl for
  variance of the random error.}
 \item{tau2}{A vector of posterior mean, the 95\% lcl and ucl for
  variance of the target function (hyperparameters).}
}
}
\description{
Summary of posterior inference on the Bayesian Gaussian process regression model
}
\examples{
library(BayesGPfit)
library(lattice)
set.seed(1224)
dat = list()
dat$x = GP.generate.grids(d=2,num_grids = 30)
curve = GP.simulate.curve.fast(dat$x,a=0.01,b=0.5,poly_degree=20L)
dat$f = curve$f + rnorm(length(curve$f),sd=1)
fast_fit = GP.fast.Bayes.fit(dat$f,dat$x,a=0.01,b=0.5,poly_degree=20L,progress_bar = TRUE)
reg_fit = GP.Bayes.fit(dat$f,dat$x,a=0.01,b=0.5,poly_degree=20L,progress_bar = TRUE)
sum_fast_fit = GP.summary(fast_fit)
sum_reg_fit = GP.summary(reg_fit)
curves = list(mean_fast = sum_fast_fit$mean,
             mean = sum_reg_fit$mean,
             lci_fast = sum_fast_fit$lci,
             lci = sum_reg_fit$lci,
             uci_fast = sum_fast_fit$uci,
             uci = sum_reg_fit$uci)
GP.plot.curves(curves,layout=c(2,3))
}
\author{
Jian Kang <jiankang@umich.edu>
}
