% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distributions.R
\name{Gamma}
\alias{Gamma}
\title{Create a Gamma Prior}
\usage{
Gamma(shape = 2, scale = 2)
}
\arguments{
\item{shape}{shape parameter}

\item{scale}{scale parameter}
}
\value{
A list with the following content
\itemize{
    \item juliavar - julia variable containing the distribution
    \item juliacode - julia code used to create the distribution
}
}
\description{
Creates a Gamma prior in Julia using Distributions.jl
}
\examples{
\dontrun{
  ## Needs previous call to `BayesFluxR_setup` which is time
  ## consuming and requires Julia and BayesFlux.jl
  BayesFluxR_setup(installJulia=TRUE, seed=123)
  net <- Chain(Dense(5, 1))
  like <- likelihood.feedforward_normal(net, Gamma(2.0, 0.5))
}

}
