% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter.R
\name{filter.TidySet}
\alias{filter.TidySet}
\alias{filter_set}
\alias{filter_element}
\alias{filter_relation}
\title{Filter TidySet}
\usage{
\method{filter}{TidySet}(.data, ...)

filter_set(.data, ...)

filter_element(.data, ...)

filter_relation(.data, ...)
}
\arguments{
\item{.data}{The TidySet object.}

\item{...}{The logical predicates in terms of the variables of the sets.}
}
\value{
A TidySet object.
}
\description{
Use filter to subset the TidySet object. You can use activate with filter or
use the specific function. The S3 method filters using all the information
on the TidySet.
}
\examples{
relations <- data.frame(
    sets = c(rep("a", 5), "b", rep("a2", 5), "b2"),
    elements = rep(letters[seq_len(6)], 2),
    fuzzy = runif(12),
    type = c(rep("Gene", 4), rep("lncRNA", 2))
)
TS <- tidySet(relations)
TS <- move_to(TS, from = "relations", to = "elements", column = "type")
filter(TS, elements == "a")
# Equivalent to filter_relation
filter(TS, elements == "a", sets == "a")
filter_relation(TS, elements == "a", sets == "a")
# Filter element
filter_element(TS, type == "Gene")
# Filter sets and by property of elements simultaneously
filter(TS, sets == "b", type == "lncRNA")
# Filter sets
filter_set(TS, sets == "b")
}
\seealso{
\code{\link[dplyr:filter]{dplyr::filter()}} and \code{\link[=activate]{activate()}}

Other methods: 
\code{\link{TidySet-class}},
\code{\link{activate}()},
\code{\link{add_column}()},
\code{\link{add_relation}()},
\code{\link{arrange.TidySet}()},
\code{\link{cartesian}()},
\code{\link{complement_element}()},
\code{\link{complement_set}()},
\code{\link{complement}()},
\code{\link{element_size}()},
\code{\link{elements}()},
\code{\link{group_by.TidySet}()},
\code{\link{group}()},
\code{\link{incidence}()},
\code{\link{intersection}()},
\code{\link{is.fuzzy}()},
\code{\link{is_nested}()},
\code{\link{move_to}()},
\code{\link{mutate.TidySet}()},
\code{\link{nElements}()},
\code{\link{nRelations}()},
\code{\link{nSets}()},
\code{\link{name_elements<-}()},
\code{\link{name_sets<-}()},
\code{\link{name_sets}()},
\code{\link{power_set}()},
\code{\link{pull.TidySet}()},
\code{\link{relations}()},
\code{\link{remove_column}()},
\code{\link{remove_element}()},
\code{\link{remove_relation}()},
\code{\link{remove_set}()},
\code{\link{rename_elements}()},
\code{\link{rename_set}()},
\code{\link{select.TidySet}()},
\code{\link{set_size}()},
\code{\link{sets}()},
\code{\link{subtract}()},
\code{\link{union}()}
}
\concept{methods}
