% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/basesets-package.R
\docType{package}
\name{BaseSet-package}
\alias{BaseSet}
\alias{BaseSet-package}
\title{BaseSet: Working with Sets the Tidy Way}
\description{
Implements a class and methods to work with sets,
    doing intersection, union, complementary sets, power sets, cartesian
    product and other set operations in a "tidy" way. These set operations
    are available for both classical sets and fuzzy sets. Import sets from
    several formats or from other several data structures.
}
\details{
It provides a class \code{\link{TidySet}} with methods to do operations with sets.
}
\examples{
set <- list("A" = letters[1:5], "B" = letters[4:7])
TS <- tidySet(set)
cardinality(TS)
intersection(TS, c("A", "B"))
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/ropensci/BaseSet}
  \item \url{https://docs.ropensci.org/BaseSet/}
  \item Report bugs at \url{https://github.com/ropensci/BaseSet/issues}
}

}
\author{
\strong{Maintainer}: Lluís Revilla Sancho \email{lluis.revilla@gmail.com} (\href{https://orcid.org/0000-0001-9747-2570}{ORCID}) [copyright holder]

Other contributors:
\itemize{
  \item Zebulun Arendsee [reviewer]
  \item Jennifer Chang [reviewer]
}

}
