% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/incidence.R
\name{incidence}
\alias{incidence}
\alias{incidence,TidySet-method}
\title{Incidence}
\usage{
incidence(object)

\S4method{incidence}{TidySet}(object)
}
\arguments{
\item{object}{Object to be coerced or tested.}
}
\value{
A matrix with elements in rows and sets in columns where the values
indicate the relationship between the element and the set.
}
\description{
Check which elements are in which sets.
}
\section{Methods (by class)}{
\itemize{
\item \code{TidySet}: Incidence of the TidySet
}}

\examples{
x <- list("a" = letters[1:5], "b" = LETTERS[3:7])
a <- tidySet(x)
incidence(a)
}
\seealso{
\code{\link{adjacency}}

Other methods: 
\code{\link{TidySet-class}},
\code{\link{activate}()},
\code{\link{add_column}()},
\code{\link{add_relation}()},
\code{\link{arrange.TidySet}()},
\code{\link{cartesian}()},
\code{\link{complement_element}()},
\code{\link{complement_set}()},
\code{\link{complement}()},
\code{\link{element_size}()},
\code{\link{elements}()},
\code{\link{filter.TidySet}()},
\code{\link{group_by.TidySet}()},
\code{\link{group}()},
\code{\link{intersection}()},
\code{\link{is.fuzzy}()},
\code{\link{is_nested}()},
\code{\link{move_to}()},
\code{\link{mutate.TidySet}()},
\code{\link{nElements}()},
\code{\link{nRelations}()},
\code{\link{nSets}()},
\code{\link{name_elements<-}()},
\code{\link{name_sets<-}()},
\code{\link{name_sets}()},
\code{\link{power_set}()},
\code{\link{pull.TidySet}()},
\code{\link{relations}()},
\code{\link{remove_column}()},
\code{\link{remove_element}()},
\code{\link{remove_relation}()},
\code{\link{remove_set}()},
\code{\link{rename_elements}()},
\code{\link{rename_set}()},
\code{\link{select.TidySet}()},
\code{\link{set_size}()},
\code{\link{sets}()},
\code{\link{subtract}()},
\code{\link{union}()}
}
\concept{methods}
