% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/median.inclusion.vs.R
\name{medianInclusion.vs}
\alias{medianInclusion.vs}
\title{Variable selection with DART}
\usage{
medianInclusion.vs(
  x.train,
  y.train,
  probit = FALSE,
  vip.selection = TRUE,
  true.idx = NULL,
  plot = FALSE,
  num.var.plot = Inf,
  theta = 0,
  omega = 1,
  a = 0.5,
  b = 1,
  augment = FALSE,
  rho = NULL,
  xinfo = matrix(0, 0, 0),
  numcut = 100L,
  usequants = FALSE,
  cont = FALSE,
  rm.const = TRUE,
  power = 2,
  base = 0.95,
  split.prob = "polynomial",
  k = 2,
  ntree = 20L,
  ndpost = 1000L,
  nskip = 1000L,
  keepevery = 1L,
  printevery = 100L,
  verbose = FALSE
)
}
\arguments{
\item{x.train}{A matrix or a data frame of predictors values with each row corresponding to an observation and each column 
corresponding to a predictor. If a predictor is a factor with \eqn{q} levels in a data frame, it is replaced with \eqn{q} dummy 
variables.}

\item{y.train}{A vector of response (continuous or binary) values.}

\item{probit}{A Boolean argument indicating whether the response variable is binary or continuous; \code{probit=FALSE} (by default)
means that the response variable is continuous.}

\item{vip.selection}{A Boolean argument indicating whether to select predictors using BART VIPs.}

\item{true.idx}{(Optional) A vector of indices of the true relevant predictors; if provided, metrics including precision, recall
and F1 score are returned.}

\item{plot}{(Optional) A Boolean argument indicating whether plots are returned or not.}

\item{num.var.plot}{The number of variables to be plotted.}

\item{theta}{Set \code{theta} parameter; zero means random.}

\item{omega}{Set \code{omega} parameter; zero means random.}

\item{a}{A sparse parameter of \eqn{Beta(a, b)} hyper-prior where \eqn{0.5<=a<=1}; a lower value induces more sparsity.}

\item{b}{A sparse parameter of \eqn{Beta(a, b)} hyper-prior; typically, \eqn{b=1}.}

\item{augment}{A Boolean argument indicating whether data augmentation is performed in the variable selection procedure 
of Linero (2018).}

\item{rho}{A sparse parameter; typically \eqn{\rho = p} where \eqn{p} is the number of predictors.}

\item{xinfo}{A matrix of cut-points with each row corresponding to a predictor and each column corresponding to a cut-point.
\code{xinfo=matrix(0.0,0,0)} indicates the cut-points are specified by BART.}

\item{numcut}{The number of possible cut-points; If a single number is given, this is used for all predictors; 
Otherwise a vector with length equal to \code{ncol(x.train)} is required, where the \eqn{i-}th element gives the number of 
cut-points for the \eqn{i-}th predictor in \code{x.train}. If \code{usequants=FALSE}, \code{numcut} equally spaced 
cut-points are used to cover the range of values in the corresponding column of \code{x.train}. 
If \code{usequants=TRUE}, then min(\code{numcut}, the number of unique values in the corresponding column of 
\code{x.train} - 1) cut-point values are used.}

\item{usequants}{A Boolean argument indicating how the cut-points in \code{xinfo} are generated; 
If \code{usequants=TRUE}, uniform quantiles are used for the cut-points; Otherwise, the cut-points are generated uniformly.}

\item{cont}{A Boolean argument indicating whether to assume all predictors are continuous.}

\item{rm.const}{A Boolean argument indicating whether to remove constant predictors.}

\item{power}{The power parameter of the polynomial splitting probability for the tree prior. Only used if 
\code{split.prob="polynomial"}.}

\item{base}{The base parameter of the polynomial splitting probability for the tree prior if \code{split.prob="polynomial"}; 
if \code{split.prob="exponential"}, the probability of splitting a node at depth \eqn{d} is \code{base}\eqn{^d}.}

\item{split.prob}{A string indicating what kind of splitting probability is used for the tree prior. If 
\code{split.prob="polynomial"}, the splitting probability in Chipman et al. (2010) is used; 
If \code{split.prob="exponential"}, the splitting probability in Rockova and Saha (2019) is used.}

\item{k}{The number of prior standard deviations that \eqn{E(Y|x) = f(x)} is away from \eqn{+/-.5}. The response 
(\code{y.train}) is internally scaled to the range from \eqn{-.5} to \eqn{.5}. The bigger \code{k} is, the more conservative 
the fitting will be.}

\item{ntree}{The number of trees in the ensemble.}

\item{ndpost}{The number of posterior samples returned.}

\item{nskip}{The number of posterior samples burned in.}

\item{keepevery}{Every \code{keepevery} posterior sample is kept to be returned to the user.}

\item{printevery}{As the MCMC runs, a message is printed every \code{printevery} iterations.}

\item{verbose}{A Boolean argument indicating whether any messages are printed out.}
}
\value{
The function \code{medianInclusion.vs()} returns two (or one if \code{vip.selection=FALSE}) plots if \code{plot=TRUE}
and a list with the following components.
\item{dart.pvip}{The vector of DART MPVIPs.}
\item{dart.pvip.imp.names}{The vector of column names of the predictors with DART MPVIP at least \eqn{0.5}.}
\item{dart.pvip.imp.cols}{The vector of column indices of the predictors with DART MPVIP at least \eqn{0.5}.}
\item{dart.precision}{The precision score for the DART approach; only returned if \code{true.idx} is provided.}
\item{dart.recall}{The recall score for the DART approach; only returned if \code{true.idx} is provided.}
\item{dart.f1}{The F1 score for the DART approach; only returned if \code{true.idx} is provided.}
\item{bart.vip}{The vector of BART VIPs; only returned if \code{vip.selection=TRUE}.}
\item{bart.vip.imp.names}{The vector of column names of the predictors with BART VIP exceeding \code{1/ncol{x.train}}; only 
returned if \code{vip.selection=TRUE}.}
\item{bart.vip.imp.cols}{The vector of column indicies of the predictors with BART VIP exceeding \code{1/ncol{x.train}}; only 
returned if \code{vip.selection=TRUE}.}
\item{bart.precision}{The precision score for the BART approach; only returned if \code{vip.selection=TRUE} and \code{true.idx} 
is provided.}
\item{bart.recall}{The recall score for the BART approach; only returned if \code{vip.selection=TRUE} and \code{true.idx} 
is provided.}
\item{bart.f1}{The F1 score for the BART approach; only returned if \code{vip.selection=TRUE} and \code{true.idx} 
is provided.}
}
\description{
This function implements the variable selection approach proposed in Linero (2018). Linero (2018) proposes DART, a variant of BART,
which replaces the discrete uniform distribution for selecting a split variable with a categorical distribution of which the event
probabilities follow a Dirichlet distribution. DART estimates the marginal posterior variable inclusion probability (MPVIP) for 
a predictor by the proportion of the posterior samples of the trees structures where the predictor is used as a split variable
at least once, and selects predictors with MPVIP at least \eqn{0.5}, yielding a median probability model.
}
\details{
See Linero (2018) or Section 2.2.3 in Luo and Daniels (2021) for details.\cr
If \code{vip.selection=TRUE}, this function also does variable selection by selecting variables whose BART VIP exceeds
\code{1/ncol{x.train}}.\cr
If \code{true.idx} is provided, the precision, recall and F1 scores are returned.\cr
If \code{plot=TRUE}, plots showing which predictors are selected are generated.
}
\examples{
## simulate data (Scenario C.M.1. in Luo and Daniels (2021))
set.seed(123)
data = mixone(100, 10, 1, FALSE)
## test medianInclusion.vs() function
res = medianInclusion.vs(data$X, data$Y, probit=FALSE, vip.selection=TRUE,  
true.idx=c(1, 2, 6:8), plot=FALSE, ntree=10, ndpost=100, nskip=100, verbose=FALSE)
}
\references{
Chipman, H. A., George, E. I. and McCulloch, R. E. (2010). 
  "BART: Bayesian additive regression trees."
   \emph{Ann. Appl. Stat.} \strong{4} 266--298.

Linero, A. R. (2018). 
  "Bayesian regression trees for high-dimensional prediction and variable selection." 
  \emph{J. Amer. Statist. Assoc.} \strong{113} 626--636.
  
Luo, C. and Daniels, M. J. (2021)
  "Variable Selection Using Bayesian Additive Regression Trees."
  \emph{arXiv preprint arXiv:2112.13998}.
  
Rockova V, Saha E (2019). 
  “On theory for BART.” 
  \emph{In The 22nd International Conference on Artificial Intelligence and Statistics} (pp. 2839–2848). PMLR.
}
\seealso{
\code{\link{permute.vs}}, \code{\link{mc.backward.vs}} and \code{\link{abc.vs}}.
}
\author{
Chuji Luo: \email{cjluo@ufl.edu} and Michael J. Daniels: \email{daniels@ufl.edu}.
}
