% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kernelize.R
\name{kernelize}
\alias{kernelize}
\title{Transform a matrix of input data into a matrix of concatenated kernel matrices}
\usage{
kernelize(m, sigma2 = 100)
}
\arguments{
\item{m}{matrix on which to compute kernels}

\item{sigma2}{numeric bandwidth (variance) for Gaussian kernels (default: 100)}
}
\value{
m.kern matrix with the kernels concatenated column-wise
}
\description{
The input matrix should have samples as the rows and features as columns. A kernel will 
computed across all training data for each unique column category. The column names
should begin with the category. E.g. for a cell line input matrix the column names
may be snp.<gene>, meth.<loci>, etc. and this function will produce similarity kernels
for all snp data separately from the methylation data.
}
\examples{
m <- matrix(rnorm(800), 8, 100, dimnames=list(paste0('sample.', 1:8), 
                          c(paste0('rna.', 1:20), paste0('meth.', 1:30), paste0('mut.', 1:50))))
m[,51:100] <- rbinom(8*50, 1, 0.5)
m.kern <- kernelize(m)
}

