% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/simulate.R
\docType{methods}
\name{simulate,hiddenmixedDiffusion-method}
\alias{simulate,hiddenmixedDiffusion-method}
\title{Simulation of hierarchical (mixed) hidden diffusion model}
\usage{
\S4method{simulate}{hiddenmixedDiffusion}(object, nsim = 1, seed = NULL, t,
  mw = 10, plot.series = TRUE)
}
\arguments{
\item{object}{class object of parameters: "hiddenmixedDiffusion"}

\item{nsim}{number of data sets to simulate. Default is 1.}

\item{seed}{optional: seed number for random number generator}

\item{t}{vector of time points}

\item{mw}{mesh width for finer Euler approximation to simulate time-continuity}

\item{plot.series}{logical(1), if TRUE, simulated series are depicted grafically}
}
\description{
Simulation of a stochastic process
  \eqn{Z_{ij} = Y_{t_{ij}} + \epsilon_{ij}, dY_t = b(\phi_j,t,Y_t)dt + \gamma \widetilde{s}(t,Y_t)dW_t, \phi_j\sim N(\mu, \Omega),
  Y_{t_0}=y_0(\phi, t_0), \epsilon_{ij}\sim N(0,\sigma^2)}.
}
\examples{
mu <- c(5, 1); Omega <- c(0.9, 0.04)
phi <- cbind(rnorm(21, mu[1], sqrt(Omega[1])), rnorm(21, mu[2], sqrt(Omega[2])))
y0.fun <- function(phi, t) phi[2]
model <- set.to.class("hiddenmixedDiffusion", y0.fun = y0.fun,
   b.fun = function(phi, t, y) phi[1],
   parameter = list(phi = phi, mu = mu, Omega = Omega, gamma2 = 1, sigma2 = 0.01))
t <- seq(0, 1, by = 0.01)
data <- simulate(model, t = t)
}

